@extends('layouts.admin.main')
@section('title', __('adminWords.plan'))
@section('style')
    <link href="{{ asset('assets/plugins/datepicker/datepicker.min.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('assets/plugins/select2/select2.min.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('assets/plugins/switchery/switchery.min.css') }}" rel="stylesheet" type="text/css">
@endsection
@section('rightbar-content')              
<div class="breadcrumbbar">
  <div class="row align-items-center">
    <div class="col-md-8 col-lg-8">
      <h4 class="page-title">{{isset($planData) ? __('adminWords.update').' '.__('adminWords.plan') : __('adminWords.create').' '.__('adminWords.plan')}}</h4>
      <div class="breadcrumb-list">
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="{{url('/')}}" title="{{ __('adminWords.home')}}">{{ __('adminWords.home') }}</a></li>
          <li class="breadcrumb-item"><a href="#" title="{{ __('adminWords.plan')}}">{{ __('adminWords.plan') }}</a></li>
        </ol>
      </div>
    </div> 
    <div class="col-md-4 col-lg-4">
        <div class="widgetbar">
    </div>                        
    </div>
  </div>          
</div>

<div class="contentbar">  
    <div class="row">
        <div class="col-lg-12">
            <div class="card m-b-30">
                <div class="card-header"> 
                    <div class="text-right">   
                        <a class="btn btn-primary" href="{{ url('plans') }}" title="{{ __('adminWords.go_back') }}">{{ __('adminWords.go_back') }}</a>
                    </div>                                  
                    <div class="row align-items-center">
                        <div class="col-6">
                        <h5 class="card-title mb-0">{{isset($planData) ? __('adminWords.update').' '.__('adminWords.plan') : __('adminWords.create').' '.__('adminWords.plan')}}</h5>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                <div class="admin-form">
                    @if(isset($planData))
                      {!! Form::model($planData, ['method'=>'post', 'files'=>true, 'route'=>['addEditPlan', $planData->id], 'id'=>'updateArtist', 'onsubmit'=>'return false', 'data-redirect' => url('plans')]) !!}
                    @else
                        {!! Form::open(['method' => 'POST', 'route' => ['addEditPlan','create'], 'id'=>'addUpdatePlanForm', 'enctype'=>"multipart/form-data", 'data-reset'=>"1",'table-reload'=>"mrclsDtToShowData", 'data-redirect' => url('plans') ]) !!}
                    @endif
                    <div class="row">
                        <div class="col-lg-6"> 
                            <div class="form-group{{ $errors->has('plan_name') ? ' has-error' : '' }}">
                                <label for="plan_name">{{ __('adminWords.plan_name') }}<sup>*</sup></label>
                                {!! Form::text('plan_name', null, ['class' => 'form-control require', 'placeholder'=>__('adminWords.enter').' '.__('adminWords.plan_name')]) !!}
                                <small class="text-danger">{{ $errors->first('plan_name') }}</small>
                            </div>    
                           
                            <div class="form-group{{$errors->has('plan_amount') ? 'has-error' : ''}} ">
                                <label for="plan_amount">{{ __('adminWords.plan').' '.__('adminWords.amount').' '.__('adminWords.apply_for_free') }}<sup>*</sup></label>
                                {!! Form::number('plan_amount', (isset($planData) ? $planData->plan_amount : 0), ['class' => 'form-control require', 'placeholder'=>__('adminWords.enter').' '.__('adminWords.plan').' '.__('adminWords.amount')]) !!}
                                <small class="text-danger">{{ $errors->first('plan_amount') }}</small>
                           </div>
                           <div class="form-group{{ $errors->has('validity') ? ' has-error' : '' }}">
                            {!! Form::label('validity', (isset($planData) && $planData->plan_amount != 0) ? __('adminWords.validity_in_months') : __('adminWords.validity_in_days'), ['class'=>'validity_month_day']) !!}
                            {!! Form::number('validity', null, ['class' => 'form-control', 'placeholder'=> __('adminWords.enter').' '.__('adminWords.validity') ]) !!}
                            <small class="text-danger">{{ $errors->first('validity') }}</small>
                            <input type="hidden" name="month_days" id="monthDays" value="0" placeholder="{{ __('Plan Data')}}">
                        </div>  
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group{{ $errors->has('is_download') ? ' has-error' : '' }} switch-main-block">
                                <div class="row">
                                    <div class="col-lg-10">
                                        {!! Form::label('download_text', __('adminWords.download_text') ) !!}
                                    </div>
                                    <div class="col-lg-2">
                                        {!! Form::checkbox('is_download', 1, (isset($planData) && $planData->is_download == 0 ? 0 : 1), ['class' => 'js-switch-primary', 'id'=>'is_download']) !!}
                                    </div>
                                </div>
                                <small class="text-danger">{{ $errors->first('is_download') }}</small>
                            </div>
                            <div class="form-group{{ $errors->has('show_advertisement') ? ' has-error' : '' }} switch-main-block">
                                <div class="row">
                                    <div class="col-lg-10">
                                        {!! Form::label('show_advertisement', __('adminWords.show_advertisement') ) !!}
                                    </div>
                                    <div class="col-lg-2">
                                        {!! Form::checkbox('show_advertisement', 1, (isset($planData) && $planData->show_advertisement == 0 ? 0 : 1), ['class' => 'js-switch-primary', 'id'=>'show_advertisement']) !!}
                                    </div>
                                </div>
                                <small class="text-danger">{{ $errors->first('show_advertisement') }}</small>
                            </div>
                           
                            <div class="form-group{{$errors->has('image') ? 'has-error' : ''}}">
                                <label for="image" class="col-lg-12">{{ __('adminWords.plan').' '.__('adminWords.image') }}<sup>*</sup></label>
                                <label for="image" class="btn btn-danger js-labelFile" data-toggle="tooltip" data-original-title="Plan Image">
                                <i class="icon fa fa-check"></i>
                                {!! Form::file('image',['class' => 'form-control hide basicImage', 'data-label'=>'atristImage', 'name'=>'image', 'data-ext'=>"['jpg','jpeg','png','svg']", 'data-image-id'=>'plan_image', 'id' => 'image', 'data-image'=>__('adminWords.image_error'),'accept' => 'image/*']) !!}
                                <span class="js-fileName">{{ __('adminWords.choose_image') }}</span>
                                </label>
                                <input type="hidden" id="image_name" value="{{(isset($planData) ? $planData->image:'')}}" placeholder="{{ __('Plan Image')}}">
                                <span class="image_title" id="atristImage">{{(isset($planData) && $planData->image != '' ? $planData->image : __('adminWords.choose_image') )}}</span>
                                <small class="text-danger">{{ $errors->first('image')}}</small>
                                <input type="hidden" id="plan_image" />
                                <p class="note_tooltip">Note: {{ __('adminWords.recommended').' size - 500X500 px' }} </p>
                            </div>
                            <div class="form-group{{ $errors->has('status') ? ' has-error' : '' }} switch-main-block">
                                <div class="row">
                                    <div class="col-lg-3">
                                        {!! Form::label('status', __('adminWords.status') ) !!}
                                    </div>
                                    <div class="col-lg-2">
                                        {!! Form::checkbox('status', 1, (isset($planData) && $planData->status == 0 ? 0 : 1), ['class' => 'js-switch-primary']) !!}
                                    </div>
                                </div>
                                <small class="text-danger">{{ $errors->first('status') }}</small>
                            </div>
                            
                        </div>
                        <div class="col-lg-8">
                            <div class="form-group"> 
                                @if(!isset($planData))
                                    <button type="reset" class="btn btn-danger" title="{{ __('adminWords.reset') }}"><i class="fa fa-ban"></i> {{__('adminWords.reset')}}</button>
                                @endif  
                                <button type="button" class="btn btn-primary" data-action="submitThisForm" title="{{isset($planData) ? __('adminWords.update') : __('adminWords.add') }}"
                                ><i class="fa fa-check-circle"></i> {{isset($planData) ? __('adminWords.update') : __('adminWords.add') }}</button>  
                            </div>
                            <div class="clear-both"></div>
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 
@section('script')
    <script src="{{ asset('assets/plugins/datepicker/datepicker.min.js') }}"></script> 
    <script src="{{ asset('assets/plugins/select2/select2.min.js') }}"></script> 
    <script src="{{ asset('assets/plugins/datepicker/i18n/datepicker.en.js') }}"></script> 
    <script src="{{ asset('assets/plugins/switchery/switchery.min.js') }}"></script> 
    <script src="{{ asset('assets/js/mrcls-custom.js') }}"></script>  
@endsection
