<?php
namespace Modules\Plan\Http\Controllers;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Plan\Entities\Plan;
use DataTables;
use Illuminate\Support\Carbon;

class PlanController extends Controller{
   
    public function index(){
        return view('plan::index');
    }

    public function planData(){
        $plans = select(['column'=>'*','table'=>'plans','order'=>['id','desc']]);
        return DataTables::of($plans)
            ->editColumn('checkbox',function($plans){
                return '<div class="inline custom-checkbox"><input name="checked" id="checkboxAll'.$plans->id.'" type="checkbox" class="custom-control-input CheckBoxes" value="'.$plans->id.'"><label for="checkboxAll'.$plans->id.'" class="custom-control-label"></label></div>';
            })
            ->editColumn('image', function($plans){
                if($plans->image != '' && file_exists(public_path('/images/plan/'.$plans->image)))
                    $src = asset('/images/plan/'.$plans->image);
                else
                    $src = asset('images/sites/500x500.png');
                return '<img src="'.$src.'" alt="" class="img-fluid" width="60px" height="60px">';
            })
            ->editColumn('validity', function($plans){
                return $plans->is_month_days == 0 ? $plans->validity.' Days' : $plans->validity.' Months';
            })
            ->editColumn('plan_amount', function($plans){
                return '$'.$plans->plan_amount;
            })
            ->editColumn('is_download', function($plans){
                return '<div class="custom-switch"><input id="switch_'.$plans->id.'" name="is_download" class="custom-control-input changeDataVal" '.($plans->is_download == 1 ? 'checked':'').' data-field="is_download" type="checkbox" data-url="'.url('plan/is_download/'.$plans->id).'"><label class="custom-control-label" for="switch_'.$plans->id.'"></label></div>';
            })
            ->editColumn('show_advertisement', function($plans){
                return '<div class="custom-switch"><input id="switch-'.$plans->id.'" name="show_advertisement" class="custom-control-input changeDataVal" '.($plans->show_advertisement == 1 ? 'checked':'').' data-field="show_advertisement" type="checkbox" data-url="'.url('plan/show_adv/'.$plans->id).'"><label class="custom-control-label" for="switch-'.$plans->id.'"></label></div>';
            })
            ->editColumn('created_at', function($plans){
                return Carbon::parse($plans->created_at)->diffForHumans(Carbon::now());
            })
            ->editColumn('status', function($plans){
                return '<div class="custom-switch"><input id="switch'.$plans->id.'" name="status" class="custom-control-input changeStatus" '.($plans->status == 1 ? 'checked':'').' type="checkbox" data-url="'.url('plan/status/'.$plans->id).'"><label class="custom-control-label" for="switch'.$plans->id.'"></label></div>';
            })
            ->addColumn('action', function ($plans) {
                return '<div class="button-list"><a class="btn btn-sm btn-success-rgba" href="'.url('plan/edit/'.$plans->id).'"><i class="feather icon-edit-2"></i></a><button type="button" data-url="'.url('plan/destroy/'.$plans->id).'" class="btn btn-sm btn-danger-rgba" id="deleteUser"><i class="feather icon-trash"></i></button></div>';
            })
            ->rawColumns(['checkbox','image','is_download','show_advertisement','status','action'])->make(true);
    }

    public function create(){
        return view('plan::addEdit');
    }

    public function addEditPlan(Request $request, $id){
        $rules = [ 'plan_name' => 'required','validity' => 'required', 'plan_amount' => 'required' ];
        $rules['image'] = (!is_numeric($id) ? 'required|mimes:jpg,jpeg,png|max:2048' : '');

        $checkValidate = validation($request->except('_token'), $rules);
        if($checkValidate['status'] == 1){
            
            $where = is_numeric($id) ? [['id','!=',$id],['plan_name','=',$request->plan_name]] : [['plan_name','=',$request->plan_name]];
            $checkPlan = Plan::where($where)->first();
            if(!empty($checkPlan) > 0){
                $resp = array('status'=>0, 'msg'=> __('adminWords.plan').' '.('adminWords.already_exist') );
            }else{
                $checkPlan = is_numeric($id) ? Plan::find($id) : [];
                $data = $request->except('_token');
                $data['is_download'] = isset($request->is_download) ? 1 : 0;
                $data['show_advertisement'] = isset($request->show_advertisement) ? 1 : 0;
                $data['status'] = isset($request->status) ? 1 : 0;
                $data['is_month_days'] = $request->month_days;
                
                if($image = $request->file('image')){
                    $name = 'plan-'.time().'.webp';
                    $data['image'] = str_replace(' ','',$name);
                    upload_image($image, public_path().'/images/plan/', $name, '500x500');                    
                    if(!empty($checkPlan) && $checkPlan->image != ''){
                        delete_file_if_exist(public_path().'/images/plan/'.$checkPlan->image);
                    }
                }
                
                $addPlan = empty($checkPlan) ? Plan::create($data) : $checkPlan->update($data);
                $resp = ($addPlan) ? ['status'=>1, 'msg'=> __('adminWords.plan').' '.__('adminWords.success_msg')] : ['status'=>0, 'msg'=> __('adminWords.error_msg') ];
            }
        }else{
            $resp = $checkValidate;
        }
        echo json_encode($resp);
    }

    public function edit($id){
        $plans = Plan::where('id',$id)->get();
        $data['planData'] = !empty($plans) ? $plans[0] : [];
        return view('plan::addEdit',$data);
    }
    
    public function destroyPlan($id){
        $resp = singleDelete([ 'table'=>'plans','column'=>['image','plan_name'], 'where'=>['id'=>$id], 'msg'=> __('adminWords.plan').' '.__('adminWords.delete_success'), 'isImage'=>public_path().'/images/plan/' ]);
        echo $resp;        
    }

    function bulkDeletePlanData(Request $request){
        $checkValidate = validation($request->all(),['checked' =>'required'], __('adminWords.atleast').' '.__('adminWords.plan').' '.__('adminWords.must_selected') );
        if($checkValidate['status'] == 1){
            $resp = bulkDeleteData(['table'=>'plans','column'=>'id', 'msg'=> __('adminWords.plan').' '.__('adminWords.delete_success'), 'request'=>$request->except('_token')]);
        }else{
            $resp = $checkValidate;
        }
        echo json_encode($resp);
    }

    function updatePlanStatus(Request $request, $id){
        $checkValidate = validation($request->all(),['status' =>'required']);
        if($checkValidate['status'] == 1){
            $resp = change_status(['table'=>'plans', 'column'=>'id', 'where'=>['id'=>$id],'data'=> ['status'=>$request->status]]);
            echo $resp;
        }else{
            echo json_encode($checkValidate);
        }
    }

    function updateDownloadStatus(Request $request, $id){
        $checkValidate = validation($request->all(),['is_download' =>'required']);
        if($checkValidate['status'] == 1){
            $resp = change_status(['table'=>'plans', 'column'=>'id', 'where'=>['id'=>$id],'data'=> ['is_download'=>$request->is_download], 'msg' => __('adminWords.data').' '.__('adminWords.success_msg') ]);
            echo $resp;
        }else{
            echo json_encode($checkValidate);
        }
    }

    function updateAdvStatus(Request $request, $id){
        $checkValidate = validation($request->all(),['show_advertisement' =>'required']);
        if($checkValidate['status'] == 1){
            $resp = change_status(['table'=>'plans', 'column'=>'id', 'where'=>['id'=>$id],'data'=> ['show_advertisement'=>$request->show_advertisement], 'msg' => __('adminWords.data').' '.__('adminWords.success_msg') ]);
            echo $resp;
        }else{
            echo json_encode($checkValidate);
        }
    }

}
