@extends('layouts.admin.main')
@section('title', __('adminWords.country'))
@section('style')
    <link href="{{ asset('assets/plugins/datatables/dataTables.bootstrap4.min.css') }}" rel="stylesheet" type="text/css" />
	<link href="{{ asset('assets/plugins/datatables/buttons.bootstrap4.min.css') }}" rel="stylesheet" type="text/css" />
@endsection
@section('rightbar-content')
 <div class="breadcrumbbar">
	<div class="row align-items-center">
		<div class="col-md-7 col-lg-7">
			<h4 class="page-title">{{ __('adminWords.all').' '.__('adminWords.country') }}</h4>
			<div class="breadcrumb-list">
				<ol class="breadcrumb">
					<li class="breadcrumb-item"><a href="{{url('/')}}" title="{{ __('adminWords.home')}}">{{ __('adminWords.home') }}</a></li>
					<li class="breadcrumb-item"><a href="#" title="{{ __('adminWords.country')}}">{{ __('adminWords.country') }}</a></li>
				</ol>
			</div>
		</div>
		<div class="col-md-5 col-lg-5">
			<div class="widgetbar">
				<a class="btn btn-primary-rgba mr-2 locationPopup" data-add="1" data-url="{{route('saveCountry','create')}}" title="{{ __('adminWords.create').' '.__('adminWords.country') }}"><i class="feather icon-plus mr-2"></i>{{ __('adminWords.create').' '.__('adminWords.country') }}</a>
				<button type="button" class="btn btn-danger" id="bulkDelete" data-msg="{{ __('adminWords.atleast').' '.__('adminWords.country').' '.__('adminWords.must_selected') }}" data-url="{{route('bulkDeleteCountry')}}" title="{{ __('adminWords.delete_selected') }}"><i class="fa fa-trash"></i> {{ __('adminWords.delete_selected') }}</button>  
			</div>                        
		</div>
	</div>          
</div>

<div class="contentbar">  
	<div class="row">
		<div class="col-lg-12"> 
			<div class="card m-b-30">
				<div class="card-header">                                
					<div class="row align-items-center">
						<div class="col-6">
							<h5 class="card-title mb-0">{{ __('adminWords.all').' '.__('adminWords.country') }}</h5>
						</div>
					</div>
				</div>
				<div class="card-body">
					<div class="table-responsive">
						<form method="post" id="locationForm">
							<table data-method="post" id="datatable-buttons" class="table table-borderless mrclsDtToShowData" data-url="{{route('locationData')}}">
								<thead>
									<tr> 
										<th class="select-checkbox"> 
											<div class="inline custom-checkbox">
												<input id="checkboxAll" type="checkbox"   placeholder="{{ __('checkboxAll') }}" class="custom-control-input selectAllUser" onchange="checkAll(this, 'CheckBoxes')">
												<label for="checkboxAll" class="custom-control-label"></label>
											</div>
										</th>
										<th>{{ __('adminWords.country').' '.__('adminWords.name') }}</th>
										<th>{{ __('adminWords.iso_2') }}</th>
										<th>{{ __('adminWords.iso_3') }}</th>
										<th>{{ __('adminWords.action') }}</th>
									</tr>
								</thead>
							</table>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<div class="modal fade" id="addEditLocation">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">{{ __('adminWords.add').' '.__('adminWords.country') }}</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close" title="{{ __('adminWords.close_modal') }}">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <form id="addcountry" method="post" onsubmit="return false" action="{{route('saveCountry', 'create')}}" data-modal="1" table-reload="mrclsDtToShowData">
        <div class="modal-body">
          <div class="form-group">
            <label for="country">{{ __('adminWords.country').' '.__('adminWords.name') }}<sup>*</sup></label>
            <input type="text" placeholder="{{ __('adminWords.add_con_plchldr') }}" name="country" class="form-control require" length="3" data-length-error="{{ __('adminWords.country_length_err') }}"/>
          </div>
        </div>
        <div class="modal-footer justify-content-between">
          <button type="button" class="btn btn-default" data-dismiss="modal" title="{{ __('adminWords.close') }}">{{ __('adminWords.close') }}</button>
          <button type="button" class="btn btn-primary" data-action="submitThisForm" id="conBtn" title="{{ __('adminWords.add') }}">{{ __('adminWords.add') }}</button>
        </div>
      </form>
    </div>
  </div>
</div>
@endsection
@section('script')
    <script src="{{ asset('assets/plugins/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/dataTables.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/dataTables.buttons.min.js') }}"></script>
	<script src="{{ asset('assets/plugins/datatables/buttons.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/jszip.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/pdfmake.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/vfs_fonts.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/buttons.html5.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/buttons.print.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/dataTables.responsive.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/responsive.bootstrap4.min.js') }}"></script>
	<script src="{{ asset('assets/plugins/sweetalert2/sweetalert2.min.js') }}"></script>      
    <script src="{{ asset('assets/js/mrcls-custom.js') }}"></script>  
@endsection
