@extends('layouts.admin.main')
@section('title', __('adminWords.city'))
@section('style')
    <link href="{{ asset('assets/plugins/datatables/dataTables.bootstrap4.min.css') }}" rel="stylesheet" type="text/css" />
	<link href="{{ asset('assets/plugins/datatables/buttons.bootstrap4.min.css') }}" rel="stylesheet" type="text/css" />
	<link href="{{ asset('assets/plugins/select2/select2.min.css') }}" rel="stylesheet" type="text/css">
@endsection
@section('rightbar-content')                
<div class="breadcrumbbar">
	<div class="row align-items-center">
		<div class="col-md-7 col-lg-7">
			<h4 class="page-title">{{ __('adminWords.all').' '.__('adminWords.city') }}</h4>
			<div class="breadcrumb-list">
				<ol class="breadcrumb">
					<li class="breadcrumb-item"><a href="{{url('/')}}" title="{{ __('adminWords.home')}}">{{ __('adminWords.home') }}</a></li>
					<li class="breadcrumb-item"><a href="#" title="{{ __('adminWords.city')}}">{{ __('adminWords.city') }}</a></li>
				</ol>
			</div>
		</div>
		<div class="col-md-5 col-lg-5">
			<div class="widgetbar">
				<a class="btn btn-primary-rgba mr-2 cityPopup" data-add="1" data-url="{{route('saveCity','create')}}" title="{{ __('adminWords.create').' '.__('adminWords.city') }}"><i class="feather icon-plus mr-2"></i>{{ __('adminWords.create').' '.__('adminWords.city') }}</a>
			</div>                        
		</div>
	</div>          
</div>

<div class="contentbar">  
	<div class="row">
		<div class="col-lg-12"> 
			<div class="card m-b-30">
				<div class="card-header">                                
					<div class="row align-items-center">
						<div class="col-6">
							<h5 class="card-title mb-0">{{ __('adminWords.all').' '.__('adminWords.city') }}</h5>
						</div>
					</div>
				</div>
				<div class="card-body">
					<div class="table-responsive">
						<form method="post" id="cityForm">
							<table data-method="post" id="datatable-buttons" class="table table-borderless mrclsDtToShowData" data-url="{{route('cityData')}}">
								<thead>
									<tr> 
										<th>#</th>
										<th>{{ __('adminWords.city').' '.__('adminWords.name') }}</th>
										<th>{{ __('adminWords.state').' '.__('adminWords.name') }}</th>
										<th>{{ __('adminWords.action') }}</th>
									</tr>
								</thead>
							</table>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<div class="modal fade" id="addEditCity">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">{{ __('adminWords.add').' '.__('adminWords.city') }}</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close" title="{{ __('adminWords.close_modal') }}">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <form id="addcity" method="post" onsubmit="return false" action="{{route('saveCity', 'create')}}" data-modal="1" table-reload="mrclsDtToShowData">
        <div class="modal-body">
			<div class="form-group">
				<label for="city">{{ __('adminWords.city').' '.__('adminWords.name') }}<sup>*</sup></label>
				<input type="text" placeholder="{{ __('adminWords.enter').' '.__('adminWords.city').' '.__('adminWords.name') }}" name="city" class="form-control require" />
            </div>
            <div class="form-group">
				<label for="state">{{ __('adminWords.select').' '.__('adminWords.state') }}<sup>*</sup></label>
				{!! Form::select('state_id', isset($state) ? $state : [], '', ['class'=>'form-control select2WithSearch state_id require', 'required', 'placeholder'=> __('adminWords.select').' '.__('adminWords.state') ]) !!}
				<small class="text-danger">{{ $errors->first('role') }}</small>
			</div>  
        </div>
        <div class="modal-footer justify-content-between">
          <button type="button" class="btn btn-default" data-dismiss="modal"  title="{{ __('adminWords.close') }}">{{ __('adminWords.close') }}</button>
          <button type="button" class="btn btn-primary" data-action="submitThisForm" title="{{ __('adminWords.add') }}">{{ __('adminWords.save') }}</button>
        </div>
      </form>      
    </div>
  </div>
</div>
@endsection
@section('script')
    <script src="{{ asset('assets/plugins/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/dataTables.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/dataTables.buttons.min.js') }}"></script>
	<script src="{{ asset('assets/plugins/datatables/buttons.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/jszip.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/pdfmake.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/vfs_fonts.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/buttons.html5.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/buttons.print.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/dataTables.responsive.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/responsive.bootstrap4.min.js') }}"></script>
	<script src="{{ asset('assets/plugins/sweetalert2/sweetalert2.min.js') }}"></script>  
	<script src="{{ asset('assets/plugins/select2/select2.min.js') }}"></script>
    <script src="{{ asset('assets/js/mrcls-custom.js') }}"></script>  
@endsection
