@extends('layouts.admin.main')
@section('title', __('adminWords.all').' '.__('adminWords.language'))
@section('style')
    <link href="{{ asset('assets/plugins/datatables/dataTables.bootstrap4.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('assets/plugins/datatables/buttons.bootstrap4.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('assets/plugins/switchery/switchery.min.css') }}" rel="stylesheet" type="text/css">
@endsection
@section('rightbar-content')
 <div class="breadcrumbbar">
	<div class="row align-items-center">
		<div class="col-md-7 col-lg-7">
			<h4 class="page-title">{{ __('adminWords.all').' '.__('adminWords.language') }}</h4>
			<div class="breadcrumb-list">
				<ol class="breadcrumb">
					<li class="breadcrumb-item"><a href="{{url('/')}}" title="{{ __('adminWords.home')}}">{{ __('adminWords.home') }}</a></li>
					<li class="breadcrumb-item"><a href="#" title="{{ __('adminWords.language')}}">{{ __('adminWords.all').' '.__('adminWords.language') }}</a></li>
				</ol>
			</div>
		</div>
		<div class="col-md-5 col-lg-5">
			<div class="widgetbar">
				<a class="btn btn-primary-rgba mr-2 languagePopup" data-add="1" data-url="{{route('addEditLanguage','create')}}" title="{{ __('adminWords.create') }}"><i class="feather icon-plus mr-2"></i>{{ __('adminWords.create').' '.__('adminWords.language') }}</a>
				<button type="button" class="btn btn-danger" id="bulkDelete" data-msg="{{ __('adminWords.atleast').' '.__('adminWords.audio_genre').' '.__('adminWords.must_selected') }}"  title="{{ __('adminWords.delete_selected') }}" data-url="{{route('language.bulk_delete')}}"><i class="fa fa-trash"></i> {{ __('adminWords.delete_selected') }}</button>  
			</div>                        
		</div>
	</div>          
</div>

<div class="contentbar">  
	<div class="row">
		<div class="col-lg-12"> 
			<div class="card m-b-30">
				<div class="card-header">                                
					<div class="row align-items-center">
						<div class="col-6">
							<h5 class="card-title mb-0">{{ __('adminWords.all').' '.__('adminWords.language') }}</h5>
						</div>
					</div>
				</div>
				<div class="card-body">
					<div class="table-responsive">
						<form method="post" id="languageForm">
							<table data-method="post" id="datatable-buttons" class="table table-borderless mrclsDtToShowData" data-url="{{route('languageData')}}">
								<thead>
									<tr> 
										<th class="select-checkbox"> 
											<div class="inline custom-checkbox">
												<input id="checkboxAll" type="checkbox"   placeholder="{{ __('checkboxAll') }}" class="custom-control-input selectAllUser" onchange="checkAll(this, 'CheckBoxes')">
												<label for="checkboxAll" class="custom-control-label"></label>
											</div>
										</th>
										<th>{{ __('adminWords.language').' '.__('adminWords.name') }} </th>
										<th>{{ __('adminWords.language').' '.__('adminWords.code') }}</th>
										<th>{{ __('adminWords.created_at') }}</th>
										<th>{{ __('adminWords.status') }}</th>
										<th>{{ __('adminWords.action') }}</th>
									</tr>
								</thead>
							</table>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<div class="modal fade" id="addUpdateLanguage">
    <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <h4 class="modal-title"></h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close" title="{{ __('adminWords.close_modal') }}">
            <span aria-hidden="true">&times;</span>
            </button>
        </div>
		<form method="post" id="addUpdateGenreForm" action="{{route('addEditLanguage','create')}}" enctype="multipart/form-data" data-reset="1" data-modal='1' data-redirect="{{ url('languages') }}">
			{{csrf_field()}}
            <div class="modal-body">
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12">
                        <div class="form-group">
                            <label for="language_name">{{ __('adminWords.language').' '.__('adminWords.name')}}<sup>*</sup></label>
                            <input type="text" placeholder="{{ __('adminWords.enter').' '.__('adminWords.language').' '.__('adminWords.name') }}" name="language_name" class="form-control require" />
                        </div>
                    </div>
                    <div class="col-lg-12 col-md-12 col-sm-12">
                        <div class="form-group">
                            <label for="language_code">{{ __('adminWords.language').' '.__('adminWords.code') }}<sup>*</sup></label>
                            <input type="text" placeholder="{{ __('adminWords.enter').' '.__('adminWords.language').' '.__('adminWords.code') }}" name="language_code" class="form-control require" />
                        </div>
                    </div>
                    <div class="col-lg-12 col-md-12 col-sm-12">
                        <div class="row">
                            <div class="col-lg-3">
                                {!! Form::label('status_switch', __('adminWords.default') ) !!}
                            </div>
                            <div class="custom-switch">
                                <input id="switchDefault" name="is_default" class="custom-control-input" type="checkbox"  placeholder="{{ __('CheckAll') }}">
                                <label class="custom-control-label" for="switchDefault"></label>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-12 col-md-12 col-sm-12">
                        <div class="row">
                            <div class="col-lg-3">
                                {!! Form::label('status_switch', __('adminWords.status') ) !!}
                            </div>
                            <div class="custom-switch">
                                <input id="switchStatus" name="status"  placeholder="{{ __('switchStatus') }}" class="custom-control-input" type="checkbox">
                                <label class="custom-control-label" for="switchStatus"></label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer justify-content-between">
                <button type="button" class="btn btn-default" data-dismiss="modal" title="{{ __('adminWords.close') }}">{{ __('adminWords.close') }}</button>
                <button type="button" class="btn btn-primary" data-action="submitThisForm" id="langBtn" title="{{ __('adminWords.add') }}">{{ __('adminWords.add') }}</button>
            </div>
        </form>
        </div>
    </div>
</div>
@endsection
@section('script')
    <script src="{{ asset('assets/plugins/switchery/switchery.min.js') }}"></script> 
    <script src="{{ asset('assets/plugins/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/dataTables.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/dataTables.buttons.min.js') }}"></script>
	<script src="{{ asset('assets/plugins/datatables/buttons.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/jszip.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/pdfmake.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/vfs_fonts.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/buttons.html5.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/buttons.print.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/dataTables.responsive.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/responsive.bootstrap4.min.js') }}"></script>
	<script src="{{ asset('assets/plugins/sweetalert2/sweetalert2.min.js') }}"></script>      
	<script src="{{ asset('assets/plugins/datepicker/datepicker.min.js') }}"></script> 
	<script src="{{ asset('assets/plugins/datepicker/i18n/datepicker.en.js') }}"></script> 
    <script src="{{ asset('assets/js/mrcls-custom.js') }}"></script>  
@endsection
