@extends('layouts.admin.main')
@section('title', __('adminWords.slider'))
@section('style')
<link href="{{ asset('assets/plugins/switchery/switchery.min.css') }}" rel="stylesheet" type="text/css">
@endsection
@section('rightbar-content')
  <div class="breadcrumbbar">
    <div class="row align-items-center">
        <div class="col-md-8 col-lg-8">
            <h4 class="page-title">{{ __('adminWords.slider') }}</h4>
            <div class="breadcrumb-list">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/')}}" title="{{ __('adminWords.home')}}">{{ __('adminWords.home') }}</a></li>
                    <li class="breadcrumb-item"><a href="#" title="{{ __('adminWords.slider')}}">{{ __('adminWords.slider') }}</a></li>
                </ol>
            </div>
        </div>
    </div>          
</div>

<div class="contentbar">                
    <div class="row">
        <div class="col-lg-12">
            <div class="card m-b-30">
                <div class="card-header"> 
                    <div class="text-right">   
                        <a class="btn btn-primary" href="{{ url('slider') }}" title="{{ __('adminWords.go_back') }}">{{ __('adminWords.go_back') }}</a>
                    </div>                                    
                    <div class="row align-items-center">
                        <div class="col-6">
                            <h5 class="card-title mb-0">{{isset($sliderData) ? __('adminWords.update').' '.__('adminWords.slider') : __('adminWords.create').' '.__('adminWords.slider') }}</h5>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                  <div class="row">
                    <div class="col-md-6">
                      <div class="admin-form"> 
                          @if(isset($sliderData))
                            {!! Form::model($sliderData, ['method' => 'POST', 'onsubmit'=>'return false', 'route'=>['addEditSlider', $sliderData->id],'files' => true, 'data-redirect' => url('slider')]) !!}
                          @else
                            {!! Form::open(['method' => 'POST','onsubmit'=>'return false',  'route'=>['addEditSlider', 'create'],'files' => true, 'data-reset'=>1, 'data-redirect' => url('slider')]) !!}
                          @endif
                          <div class="form-group{{ $errors->has('title') ? ' has-error' : '' }}">
                            <label for="title">{{ __('adminWords.slider').' '.__('adminWords.title') }}<sup>*</sup></label>
                            {!! Form::text('title', null, ['class' => 'form-control require','required', 'placeholder'=>__('adminWords.enter').' '.__('adminWords.title') ]) !!}
                            <small class="text-danger">{{ $errors->first('title') }}</small>
                          </div>  
                          <div class="form-group{{ $errors->has('link') ? ' has-error' : '' }}">
                            <label for="link">{{ __('adminWords.slider').' '.__('adminWords.link') }}<sup>*</sup></label>
                            {!! Form::text('link', null, ['class' => 'form-control', 'placeholder'=>__('adminWords.enter').' '.__('adminWords.link'), 'data-valid'=>'url', 'data-error'=>__('adminWords.invalid').' '.__('adminWords.link').'.']) !!}
                            <small class="text-danger">{{ $errors->first('link') }}</small>
                          </div>
                          
                        <div class="form-group{{ $errors->has('image') ? ' has-error' : '' }} input-file-block">
                          <label for="image">{{ __('adminWords.slider').' '.__('adminWords.image') }}<sup>*</sup></label>
                          {!! Form::file('image', ['class' => 'input-file basicImage d-none '.(isset($sliderData) ? '':' require'), 'data-id'=>'', 'data-label'=>'sliderLabel', 'id'=>'image','required','accept' => 'image/*']) !!}
                          <label for="image" class="btn btn-danger js-labelFile" data-toggle="tooltip" data-original-title="Slider Image">
                            <i class="icon fa fa-check"></i>
                            <span class="js-fileName">{{ __('adminWords.choose_image') }}</span>
                          </label>
                          <span class="info" id="sliderLabel">{{ isset($sliderData) ? $sliderData->image : __('adminWords.choose_image') }}</span>
                          <small class="text-danger">{{ $errors->first('image') }}</small>
                          <p class="note_tooltip">Note: {{ __('adminWords.recommended').' size - 1660X800 px' }} </p>
                        </div>  
                        <div class="form-group{{ $errors->has('status') ? ' has-error' : '' }} switch-main-block">
                          <div class="row">
                            <div class="col-lg-3">
                              {!! Form::label('status', __('adminWords.status') ) !!}
                            </div>
                            <div class="col-lg-2">
                              {!! Form::checkbox('status', 1, (isset($sliderData) ? $sliderData->status : 1), ['class' => 'js-switch-primary']) !!}
                            </div>
                          </div>
                          <div class="col-xs-12">
                            <small class="text-danger">{{ $errors->first('status') }}</small>
                          </div>
                        </div>

                        <div class="col-lg-8">
                          <div class="form-group">    
                          @if(isset($sliderData))        
                            <button type="button" data-action="submitThisForm" class="btn btn-primary" title="{{ __('adminWords.update') }}"><i class="fa fa-check-circle"></i> {{ __('adminWords.update') }}</button>  
                          @else
                            <button type="reset" class="btn btn-danger" title="{{ __('adminWords.reset') }}"><i class="fa fa-ban"></i> {{ __('adminWords.reset') }}</button>
                            <button type="button" data-action="submitThisForm" class="btn btn-primary" title="{{ __('adminWords.create') }}"><i class="fa fa-check-circle"></i> {{ __('adminWords.create') }}</button>  
                            @endif
                          </div>
                          <div class="clear-both"></div>
                        {!! Form::close() !!}
                      </div>
                    </div>
                  </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 
@section('script')
<script src="{{ asset('assets/plugins/switchery/switchery.min.js') }}"></script> 
<script src="{{asset('assets/js/mrcls-custom.js')}}"></script>
@endsection 
