@extends('layouts.admin.main')
@section('title', __('adminWords.pages'))
@section('style')
<link href="{{asset('assets/plugins/summernote/summernote-bs4.css')}}" rel="stylesheet" type="text/css"> 
<link href="{{ asset('assets/plugins/switchery/switchery.min.css') }}" rel="stylesheet" type="text/css">
@endsection
@section('rightbar-content')                 
<div class="breadcrumbbar">
    <div class="row align-items-center">
        <div class="col-md-8 col-lg-8">
            <h4 class="page-title">{{ __('adminWords.pages') }}</h4>
            <div class="breadcrumb-list">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/')}}" title="{{ __('adminWords.home')}}">{{ __('adminWords.home') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{url('admin/pages')}}" title="{{ __('adminWords.pages')}}">{{ __('adminWords.pages') }}</a></li>
                </ol>
            </div>
        </div>
    </div>          
</div>

<div class="contentbar">                
    <div class="row">
        <div class="col-lg-12">
            <div class="card m-b-30">
                <div class="card-header">    
                    <div class="text-right">   
                        <a class="btn btn-primary" href="{{ url('pages') }}" title="{{ __('adminWords.go_back') }}">{{ __('adminWords.go_back') }}</a>
                    </div>                               
                    <div class="row align-items-center">
                        <div class="col-6">
                            <h5 class="card-title mb-0">{{isset($pageData) ? __('adminWords.update').' '.__('adminWords.page') : __('adminWords.create').' '.__('adminWords.page')}}</h5>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                  <div class="row">
                    <div class="col-md-6">
                      <div class="admin-form"> 
                      @if(isset($pageData))
                        {!! Form::model($pageData, ['method' => 'POST', 'onsubmit'=>'return false', 'route'=>['addEditPage', $pageData->id],'files' => true, 'data-redirect' => url('/pages')]) !!}
                      @else
                        {!! Form::open(['method' => 'POST','onsubmit'=>'return false',  'route'=>['addEditPage', 'create'],'files' => true, 'data-reset'=>1, 'data-redirect' => url('/pages')]) !!}
                      @endif
                          <div class="form-group{{ $errors->has('title') ? ' has-error' : '' }}">
                            <label for="title">{{ __('adminWords.page').' '.__('adminWords.title') }}<sup>*</sup></label>
                            {!! Form::text('title', null, ['class' => 'form-control require', 'required','placeholder' => __('adminWords.enter').' '.__('adminWords.page').' '.__('adminWords.title')]) !!}
                            <small class="text-danger">{{ $errors->first('title') }}</small>
                          </div>  
                          <div class="form-group{{ $errors->has('detail') ? ' has-error' : '' }}">
                            <label for="detail">{{ __('adminWords.description') }}<sup>*</sup></label>
                            {!! Form::textarea('detail', null, ['id' => 'summernote','class' => 'form-control require' ,'required']) !!}
                            <small class="text-danger">{{ $errors->first('detail') }}</small>
                          </div> 
                          <div class="form-group{{ $errors->has('is_active') ? ' has-error' : '' }} switch-main-block">
                            <div class="row">
                              <div class="col-lg-3">
                                {!! Form::label('is_active', __('adminWords.status') ) !!}
                              </div>
                              <div class="col-lg-2">
                                {!! Form::checkbox('is_active', 1, (isset($pageData) &&   $pageData->is_active == 0 ? 0 : 1), ['class' => 'js-switch-primary require']) !!}
                              </div>
                            </div>
                            <div class="col-xs-12">
                              <small class="text-danger">{{ $errors->first('is_active') }}</small>
                            </div>
                          </div>
                          
                          <div class="form-group">    
                          @if(isset($pageData))     
                            <button type="button" class="btn btn-primary" data-action="submitThisForm" title="{{ __('adminWords.update') }}"><i class="fa fa-check-circle"></i> {{ __('adminWords.update') }}</button>  
                          @else
                            <button type="reset" class="btn btn-danger" title="{{ __('adminWords.reset') }}"><i class="fa fa-ban"></i> {{ __('adminWords.reset') }}</button>
                            <button type="button" class="btn btn-primary" data-action="submitThisForm" title="{{ __('adminWords.create') }}"><i class="fa fa-check-circle"></i> {{ __('adminWords.create') }}</button>  
                          @endif   
                          </div>
                          <div class="clear-both"></div>
                        {!! Form::close() !!}
                      </div>
                    </div>
                  </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 
@section('script')
<script src="{{asset('assets/plugins/summernote/summernote-bs4.min.js')}}"></script>
<script src="{{ asset('assets/plugins/switchery/switchery.min.js') }}"></script> 
<script src="{{asset('assets/js/mrcls-custom.js')}}"></script>
@endsection 
