@extends('layouts.admin.main')
@section('title', __('adminWords.faq'))
@section('style')
    <link href="{{ asset('assets/plugins/summernote/summernote-bs4.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('assets/plugins/switchery/switchery.min.css') }}" rel="stylesheet" type="text/css">
@endsection

@section('rightbar-content')

    <div class="breadcrumbbar">
        <div class="row align-items-center">
            <div class="col-md-8 col-lg-8">
                <h4 class="page-title">{{ __('adminWords.faq') }}</h4>
                <div class="breadcrumb-list">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ url('/') }}"
                                title="{{ __('adminWords.home') }}">{{ __('adminWords.home') }}</a></li>
                        <li class="breadcrumb-item"><a href="{{ url('admin/faq') }}"
                                title="{{ __('adminWords.faq') }}">{{ __('adminWords.faq') }}</a></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="contentbar">
        <div class="row">
            <div class="col-lg-12">
                <div class="card m-b-30">
                    <div class="card-header">
                        <div class="text-right">
                            <a class="btn btn-primary" href="{{ url('faq') }}" title="{{ __('adminWords.go_back') }}">{{ __('adminWords.go_back') }}</a>
                        </div>
                        <div class="row align-items-center">
                            <div class="col-6">
                                <h5 class="card-title mb-0">
                                    {{ isset($faqs) ? __('adminWords.update') . ' ' . __('adminWords.faq') : __('adminWords.create') . ' ' . __('adminWords.faq') }}
                                </h5>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="admin-form">
                                    @if (isset($faqs))
                                        {!! Form::model($faqs, ['method' => 'post','files' => true,'id' => 'updateFaq','route' => ['faq.update', $faqs->id],'data-redirect' => url('/faq'),]) !!}
                                    @else
                                        {!! Form::open(['method' => 'POST','files' => true,'route' => ['faq.update', 'addFaq'],'data-reset' => 1,'data-redirect' => url('/faq'),]) !!}
                                    @endif

                                    <div class="form-group{{ $errors->has('question') ? ' has-error' : '' }}">
                                        <label for="question">{{ __('adminWords.question') }}<sup>*</sup></label>
                                        {!! Form::text('question', null, [
                                            'class' => 'form-control require',
                                            'required',
                                            'placeholder' => __('adminWords.enter') . ' ' . __('adminWords.question'),
                                        ]) !!}
                                        <small class="text-danger">{{ $errors->first('question') }}</small>
                                    </div>

                                    <div class="form-group{{ $errors->has('answer') ? ' has-error' : '' }}">
                                        <label for="answer">{{ __('adminWords.answer') }}<sup>*</sup></label>
                                        {!! Form::textarea('answer', null, ['class' => 'form-control require', 'required', 'rows' => 3 ,  'placeholder' => __('adminWords.enter') . ' ' . __('adminWords.answer'),]) !!}
                                        <small class="text-danger">{{ $errors->first('answer') }}</small>
                                    </div>
                                    <div
                                        class="form-group{{ $errors->has('status') ? ' has-error' : '' }} switch-main-block">
                                        <div class="row">
                                            <div class="col-lg-3">
                                                {!! Form::label('Status', __('adminWords.status')) !!}
                                            </div>
                                            <div class="col-lg-2">
                                                {!! Form::checkbox('status', 1, isset($faqs) && $faqs->status == 0 ? 0 : 1, ['class' => 'js-switch-primary']) !!}
                                            </div>
                                        </div>
                                        <div class="col-xs-12">
                                            <small class="text-danger">{{ $errors->first('status') }}</small>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        @if (!isset($faqs))
                                            <button type="reset" class="btn btn-danger" title="{{ __('adminWords.reset') }}"><i class="fa fa-ban"></i>
                                                {{ __('adminWords.reset') }}</button>
                                        @endif
                                        <button type="button" class="btn btn-primary" data-action="submitThisForm" title="{{ isset($faqs) ? __('adminWords.update') : __('adminWords.add') }}"><i
                                                class="fa fa-check-circle"></i>
                                            {{ isset($faqs) ? __('adminWords.update') : __('adminWords.add') }}</button>
                                    </div>
                                    <div class="clear-both"></div>
                                    {!! Form::close() !!}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script src="{{ asset('assets/plugins/summernote/summernote-bs4.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/switchery/switchery.min.js') }}"></script>
    <script src="{{ asset('assets/js/mrcls-custom.js') }}"></script>
@endsection
