@extends('layouts.admin.main')
@section('title', __('adminWords.comment'))
@section('style')
    <link href="{{ asset('assets/plugins/datatables/dataTables.bootstrap4.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('assets/plugins/datatables/buttons.bootstrap4.min.css') }}" rel="stylesheet" type="text/css" />
@endsection
@section('rightbar-content')
    <div class="breadcrumbbar">
        <div class="row align-items-center">
            <div class="col-md-7 col-lg-7">
                <h4 class="page-title">{{ __('adminWords.comment') }}</h4>
                <div class="breadcrumb-list">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ url('/') }}"
                                title="{{ __('adminWords.home') }}">{{ __('adminWords.home') }}</a></li>
                        <li class="breadcrumb-item"><a href="#"
                                title="{{ __('adminWords.comment') }}">{{ __('adminWords.comment') }}</a></li>
                    </ol>
                </div>
            </div>
            <div class="col-md-5 col-lg-5">
                <div class="widgetbar">
                    <button type="button" class="btn btn-danger" id="bulkDelete"
                        data-msg="{{ __('adminWords.atleast') . ' ' . __('adminWords.comment') . ' ' . __('adminWords.must_selected') }}"
                        data-url="{{ route('comment.delete') }}" title="{{ __('adminWords.delete_selected') }}"><i class="fa fa-trash"></i>
                        {{ __('adminWords.delete_selected') }}</button>
                </div>
            </div>
        </div>
    </div>

    <div class="contentbar">
        <div class="row">
            <div class="col-lg-12">
                <div class="card m-b-30">
                    <div class="card-header">
                        <div class="row align-items-center">
                            <div class="col-6">
                                <h5 class="card-title mb-0">{{ $type == 'blog' ? $blog_name : $audio_name }}</h5>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <form method="post" id="commentDataForm">
                                <table id="datatable-buttons" class="table table-borderless mrclsDtToShowData"
                                    data-url="{{ url('commentData/' . $type . '/' . ($type == 'blog' ? $blog_id : $audio_id)) }}"
                                    data-method="post">
                                    <thead>
                                        <tr>
                                            <th class="select-checkbox">
                                                <div class="inline custom-checkbox">
                                                    <input id="checkboxAll" type="checkbox"
                                                    placeholder="{{ __('checkboxAll') }}" class="custom-control-input selectAllUser"
                                                        onchange="checkAll(this, 'CheckBoxes')">
                                                    <label for="checkboxAll" class="custom-control-label"></label>
                                                </div>
                                            </th>
                                            <th>{{ __('adminWords.user_name') }}</th>
                                            <th>{{ __('adminWords.comment') }}</th>
                                            <th>{{ __('adminWords.comment_at') }}</th>
                                            <th>{{ __('adminWords.show_on_dashboard') }}</th>
                                            <th>{{ __('adminWords.action') }}</th>
                                        </tr>
                                    </thead>
                                </table>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="addReply">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">{{ __('adminWords.add') . ' ' . __('adminWords.reply') }}</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close" title="{{ __('adminWords.close_modal') }}">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="add_reply" method="post" onsubmit="return false" action="{{ url('comment/reply/') }}"
                    data-modal="1" table-reload="mrclsDtToShowData">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="replyBox">{{ __('adminWords.reply') }}<sup>*</sup></label>
                            <textarea name="reply" placeholder="{{ __('adminWords.enter') . ' ' . __('adminWords.reply') }}"
                                class="form-control require" rows="3" id="replyBox"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="button" class="btn btn-default"
                            data-dismiss="modal" title="{{ __('adminWords.close') }}">{{ __('adminWords.close') }}</button>
                        <button type="button" class="btn btn-primary"
                            data-action="submitThisForm" title="{{ __('adminWords.reply') }}">{{ __('adminWords.reply') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script src="{{ asset('assets/plugins/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/dataTables.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/dataTables.buttons.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/buttons.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/jszip.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/pdfmake.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/vfs_fonts.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/buttons.html5.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/buttons.print.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/dataTables.responsive.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/responsive.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/sweetalert2/sweetalert2.min.js') }}"></script>
    <script src="{{ asset('assets/js/mrcls-custom.js') }}"></script>
@endsection
