@extends('layouts.admin.main')
@section('title', __('adminWords.blog'))
@section('style')
<link href="{{asset('assets/plugins/summernote/summernote-bs4.css')}}" rel="stylesheet" type="text/css">
<link href="{{ asset('assets/plugins/switchery/switchery.min.css') }}" rel="stylesheet" type="text/css">
@endsection
@section('rightbar-content')

<div class="breadcrumbbar">
    <div class="row align-items-center">
        <div class="col-md-8 col-lg-8">
            <h4 class="page-title">{{ __('adminWords.blog') }}</h4>
            <div class="breadcrumb-list">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/')}}" title="{{ __('adminWords.home')}}">{{ __('adminWords.home') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{url('admin/blog')}}" title="{{ __('adminWords.blog')}}">{{ __('adminWords.blog') }}</a></li>
                </ol>
            </div>
        </div>
    </div>          
</div>
   
<div class="contentbar">                
    <div class="row">
        <div class="col-lg-12">
            <div class="card m-b-30">
                <div class="card-header">   
                    <div class="text-right">   
                        <a class="btn btn-primary" href="{{ url('blog') }}" title="{{ __('adminWords.go_back') }}">{{ __('adminWords.go_back') }}</a>
                    </div>                               
                    <div class="row align-items-center">
                        <div class="col-6">
                            <h5 class="card-title mb-0">{{ (isset($blogData)) ? __('adminWords.update').' '.__('adminWords.blog') : __('adminWords.create').' '.__('adminWords.blog') }}</h5>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                  <div class="row">
                    <div class="col-md-6">
                      <div class="admin-form"> 
                        @if(isset($blogData))
                             {!! Form::model($blogData, ['method'=>'post', 'files'=>true, 'id'=>'updateBlog', 'onsubmit'=>'return false', 'route'=>['addEditBlog', $blogData->id], 'data-redirect' => url('/blog')]) !!}
                        @else
                            {!! Form::open(['method' => 'POST','files' => true, 'onsubmit'=>'return false', 'route'=>['addEditBlog','create'], 'data-reset' => 1, 'data-redirect' => url('/blog')]) !!}
                        @endif
                          <div class="form-group{{ $errors->has('title') ? ' has-error' : '' }}">
                            <label for="title">{{  __('adminWords.blog').' '.__('adminWords.title') }}<sup>*</sup></label>
                            {!! Form::text('title', null, ['class' => 'form-control require', 'required', 'placeholder' => __('adminWords.enter').' '.__('adminWords.blog').' '.__('adminWords.title')]) !!}
                            <small class="text-danger">{{ $errors->first('title') }}</small>
                          </div>  
                          <div class="form-group{{ $errors->has('blog_cat_id') ? ' has-error' : '' }}">
                            <label for="blog_cat_id">{{ __('adminWords.select').' '.__('adminWords.blog').' '.__('adminWords.category') }}<sup>*</sup></label>
                            {!! Form::select('blog_cat_id', $blog_category, (!empty($blogData) ? $blogData->blog_cat_id : ''), ['class' => 'form-control select2 require','required','placeholder'=> __('adminWords.select').' '.__('adminWords.blog').' '.__('adminWords.category')]) !!}
                            <small class="text-danger">{{ $errors->first('blog_cat_id') }}</small>
                          </div>
                          <div class="form-group{{ $errors->has('detail') ? ' has-error' : '' }}">
                            <label for="detail">{{ __('adminWords.description') }}<sup>*</sup></label>
                            {!! Form::textarea('detail', null, ['id' => 'summernote','class' => 'form-control require' ,'required','placeholder' =>__('adminWords.enter').' '.__('adminWords.blog').' '.__('adminWords.detail')] ) !!}
                            <small class="text-danger">{{ $errors->first('detail') }}</small>
                          </div>                                          
                          <div class="form-group{{ $errors->has('is_active') ? ' has-error' : '' }} switch-main-block">
                            <div class="row">
                              <div class="col-lg-3">
                                {!! Form::label('is_active', __('adminWords.status') ) !!}
                              </div>
                              <div class="col-lg-2">
                                  {!! Form::checkbox('is_active', 1, 1, ['class' => 'js-switch-primary']) !!}
                              </div>
                            </div>
                            <div class="col-xs-12">
                              <small class="text-danger">{{ $errors->first('is_active') }}</small>
                            </div>
                          </div>
                          <div class="form-group{{ $errors->has('image') ? ' has-error' : '' }} input-file-block">
                            <label for="image">{{ __('adminWords.image') }}<sup>*</sup></label>
                            {!! Form::file('image', ['class' => 'input-file hide basicImage', 'id'=>'image', 'data-label'=>'BlogLabel', 'data-ext'=>"['jpg','jpeg','png']", 'data-image-id'=>'blogImage','accept' => 'image/*']) !!}
                            <label for="image" class="btn btn-danger js-labelFile" data-toggle="tooltip" data-original-title="{{ __('Blog Image') }}">
                              <i class="icon fa fa-check"></i>
                              <span class="js-fileName">{{ __('adminWords.choose_image') }}</span>
                            </label>
                            <span class="info" id="BlogLabel">{{!empty($blogData) && $blogData->image != '' ? $blogData->image : __('adminWords.choose_image') }}</span>
                            <input type="hidden" id="blogImage"  placeholder="{{ __('Blog Image')}}"/>
                            <small class="text-danger">{{ $errors->first('image') }}</small>
                            <p class="note_tooltip">Note: {{ __('adminWords.recommended').' size - 1050X700 px' }} </p>
                          </div>  
                          <div class="form-group">            
                            @if(isset($blogData))
                              <button type="button" class="btn btn-primary" data-action="submitThisForm" title="{{ __('adminWords.update') }}"><i class="fa fa-check-circle"></i> {{ __('adminWords.update') }}</button>  
                            @else
                              <button type="reset" class="btn btn-danger" title="{{ __('adminWords.reset') }}"><i class="fa fa-ban"></i> {{ __('adminWords.reset') }}</button>
                              <button type="button" class="btn btn-primary" data-action="submitThisForm" title="{{ __('adminWords.create') }}"><i class="fa fa-check-circle"></i> {{ __('adminWords.create') }}</button>  
                            @endif
                          </div>
                          <div class="clear-both"></div>
                        {!! Form::close() !!}
                      </div>
                    </div>
                  </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 
@section('script')
<script src="{{asset('assets/plugins/summernote/summernote-bs4.min.js')}}"></script>
<script src="{{ asset('assets/plugins/switchery/switchery.min.js') }}"></script> 
<script src="{{asset('assets/js/mrcls-custom.js')}}"></script>
@endsection
 