<?php
namespace Modules\Coupon\Http\Controllers;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Coupon\Entities\Coupon;
use DataTables;
use Illuminate\Support\Carbon;
use Modules\Plan\Entities\Plan;

class CouponController extends Controller
{
    public function index(){
        return view('coupon::index');
    } 

    public function couponData(){
        $coupon = select(['column' => ['*'], 'table' => 'coupons', 'order'=>['id','desc'] ]);
        return DataTables::of($coupon)
            ->editColumn('checkbox',function($coupon){
                return '<div class="inline custom-checkbox"><input name="checked" id="checkboxAll'.$coupon->id.'" type="checkbox" class="custom-control-input CheckBoxes" value="'.$coupon->id.'"><label for="checkboxAll'.$coupon->id.'" class="custom-control-label"></label></div>';
            })
           
            ->editColumn('starting_date', function($coupon){
                return date('d-m-Y', strtotime($coupon->starting_date));
            })
            ->editColumn('expiry_date', function($coupon){
                return date('d-m-Y', strtotime($coupon->expiry_date));
            })
            ->editColumn('applicable_on', function($coupon){
                return $coupon->applicable_on == 0 ? 'All Section' : 'Plans';
            })
            ->editColumn('created_at', function($coupon){
                return Carbon::parse($coupon->created_at)->diffForHumans(Carbon::now());
            })
            ->editColumn('status', function($coupon){
                return '<div class="custom-switch"><input id="switch'.$coupon->id.'" name="status" class="custom-control-input changeStatus" '.($coupon->status == 1 ? 'checked':'').' type="checkbox" data-url="'.url('coupon/status/'.$coupon->id).'"><label class="custom-control-label" for="switch'.$coupon->id.'"></label></div>';
            })
            ->addColumn('action', function ($coupon) {
                return '<div class="button-list"><a class="btn btn-sm btn-success-rgba" href="'.url('coupon/edit/'.$coupon->id).'"><i class="feather icon-edit-2"></i></a><button type="button" data-url="'.url('coupon/destroy/'.$coupon->id).'" class="btn btn-sm btn-danger-rgba" id="deleteUser"><i class="feather icon-trash"></i></button></div>';
            })
            ->rawColumns(['checkbox','status','action'])->make(true);
    }

    public function addEditCoupon(Request $request, $id){
        $rules = [ 'coupon_code' => 'required','discount_type' => 'required', 'coupon_used_count' => 'required', 'starting_date' => 'required', 'expiry_date' => 'required' ];
        if($request->applicable_on == 1){
            $rules['plan_id'] = 'required';
        }
       
        $checkValidate = validation($request->except('_token'), $rules);
        if($checkValidate['status'] == 1){
            $where = is_numeric($id) ? [['id','!=',$id],['coupon_code','=',$request->coupon_code] ] : [ ['coupon_code','=',$request->coupon_code] ];
            $checkCoupon = Coupon::where($where)->first();
            if(!empty($checkCoupon) > 0){
                $resp = array('status'=>0, 'msg'=> __('adminWords.coupon').' '.__('already_exist'));
            }else{
                $checkCoupon = is_numeric($id) ? Coupon::find($id) : [];
                $data = $request->except('_token');
                $data['status'] = isset($request->status) ? 1 : 0;
                $data['plan_id'] = $request->applicable_on == 1 ? json_encode($request->plan_id) : '';
                
                $addCoupon = empty($checkCoupon) ? Coupon::create($data) : $checkCoupon->update($data);
                $resp = ($addCoupon) ? ['status'=>1, 'msg'=> __('adminWords.coupon').' '.__('adminWords.success_msg')] : ['status'=>0, 'msg'=> __('adminWords.error_msg') ];
            }
        }else{
           $resp = $checkValidate;
        }
       echo json_encode($resp);
    }
    
    public function createCoupon(){
        $data['plan'] = Plan::where('status', 1)->pluck('plan_name', 'id')->all();
        return view('coupon::addEdit', $data);
    }

    public function editCoupon($id){
        $data['couponData'] = Coupon::find($id);
        $data['plan'] = Plan::where('status', 1)->pluck('plan_name', 'id')->all();
        return view('coupon::addEdit', $data);
    }

    function updateCouponStatus(Request $request, $id){
        $checkValidate = validation($request->all(),['status' =>'required']);
        if($checkValidate['status'] == 1){
            $resp = change_status(['table'=>'coupons', 'column'=>'id', 'where'=>['id'=>$id],'data'=> ['status'=>$request->status]]);
            echo $resp;
        }else{
            echo json_encode($checkValidate);
        }
    }

    public function destroyCoupon($id){
        $resp = singleDelete([ 'table'=>'coupons','column'=>['coupon_code'], 'where'=>['id'=>$id], 'msg'=> __('adminWords.coupon').' '.__('adminWords.delete_success')]);
        echo $resp;        
    }

    function bulkDeleteCoupon(Request $request){
        $checkValidate = validation($request->all(),['checked' =>'required'], __('adminWords.atleast').' '.__('adminWords.coupon').' '.__('adminWords.must_selected') );
        if($checkValidate['status'] == 1){
            $resp = bulkDeleteData(['table'=>'coupons','column'=>'id', 'msg'=>__('adminWords.coupon').' '.__('adminWords.delete_success'), 'request'=>$request->except('_token')]);
        }else{
            $resp = $checkValidate;
        }
        echo json_encode($resp);
    }
}
