@extends('layouts.admin.main')
@section('title', __('adminWords.audio'))
@section('style')
<link href="{{ asset('assets/plugins/datepicker/datepicker.min.css') }}" rel="stylesheet" type="text/css">
<link href="{{asset('assets/plugins/summernote/summernote-bs4.css')}}" rel="stylesheet" type="text/css">
<link href="{{ asset('assets/plugins/select2/select2.min.css') }}" rel="stylesheet" type="text/css">
<link href="{{ asset('assets/plugins/switchery/switchery.min.css') }}" rel="stylesheet" type="text/css">
@endsection
@section('rightbar-content')               
<div class="breadcrumbbar">
    <div class="row align-items-center">
        <div class="col-md-8 col-lg-8">
            <h4 class="page-title">{{ isset($audioData) ? __('adminWords.update').' '.__('adminWords.audio') : __('adminWords.create').' '.__('adminWords.audio') }}</h4>
            <div class="breadcrumb-list">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/')}}" title="{{ __('adminWords.home')}}">{{ __('adminWords.home') }}</a></li>
                    <li class="breadcrumb-item"><a href="#" title="{{ __('adminWords.audio')}}">{{ __('adminWords.audio') }}</a></li>
                </ol>
            </div>
        </div>
    </div>          
</div>

<div class="contentbar">                
    <div class="row">
        <div class="col-lg-12">
            <div class="card m-b-30">
                <div class="card-header">     
                    <div class="text-right">   
                        <a class="btn btn-primary" href="{{ url('audio') }}" title="{{ __('adminWords.go_back') }}">{{ __('adminWords.go_back') }}</a>
                    </div>                             
                    <div class="row align-items-center">
                        <div class="col-6">
                            <h5 class="card-title mb-0">{{ isset($audioData) ? __('adminWords.update').' '.__('adminWords.audio') : __('adminWords.create').' '.__('adminWords.audio') }}</h5>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                  <div class="admin-form">
                    @if(isset($audioData))
                      {!! Form::model($audioData, ['method'=>'post', 'files'=>true, 'route'=>['addEditAudio', $audioData->id], 'id'=>'updateAudio', 'onsubmit'=>'return false', 'data-redirect' => url('/audio')]) !!}
                    @else
                      {!! Form::open(['method' => 'POST', 'route'=>['addEditAudio','add'], 'data-reset'=>1, 'files' => true, 'onsubmit'=>'return false', 'data-redirect' => url('/audio')]) !!}
                    @endif
                    <div class="row">
                        <div class="col-lg-6"> 
                            <div class="form-group{{$errors->has('audio_title') ? 'has-error' : ''}}">
                              <label for="audio_title">{{  __('adminWords.audio').' '.__('adminWords.title') }}<sup>*</sup></label>
                              {!! Form::text('audio_title', null, ['class' => 'form-control require', 'required', 'placeholder'=>  __('adminWords.enter').' '.__('adminWords.audio').' '.__('adminWords.title') ]) !!}
                              <small class="text-danger">{{ $errors->first('audio_title')}}</small>
                            </div>
                            <div class="form-group{{ $errors->has('audio_genre_id') ? ' has-error' : '' }}">
                                <label for="audio_genre_id">{{ __('adminWords.select').' '.__('adminWords.audio_genre') }}<sup>*</sup></label>
                                {!! Form::select('audio_genre_id', $audioGenre, (isset($audioData) ? $audioData->audio_genre_id : ''), ['class' => 'form-control select2WithSearch require','placeholder' => __('adminWords.choose') ]) !!}
                                <small class="text-danger">{{ $errors->first('audio_genre_id') }}</small>
                            </div> 
                            <div class="form-group{{ $errors->has('artist_id') ? ' has-error' : '' }}">
                                <label for="artist_id">{{ __('adminWords.select').' '.__('adminWords.artist') }}<sup>*</sup></label>
                                <select name="artist_id[]" id="" class="form-control multipleSelectWithSearch require" data-placeholder="{{__('adminWords.choose')}}"  multiple="multiple">
                                    @foreach($artist as $key=>$artists) 
                                        <option value="{{$key}}" @if(isset($audioData)) @foreach(json_decode($audioData->artist_id) as $aid) {{ $aid == $key ? "selected" : "" }} @endforeach @endif >{{ $artists }}</option>
                                    @endforeach
                                </select>

                              <small class="text-danger">{{ $errors->first('artist_id') }}</small>
                          </div> 
                          <div class="form-group{{ $errors->has('audio_language') ? ' has-error' : '' }}">
                                <label for="audio_language">{{ __('adminWords.select').' '.__('adminWords.language') }}<sup>*</sup></label>
                                {!! Form::select('audio_language', $language, (isset($audioData) ? $audioData->audio_language : ''), ['class' => 'form-control select2WithSearch require','placeholder' => __('adminWords.choose')]) !!}
                                <small class="text-danger">{{ $errors->first('audio_language') }}</small>
                          </div> 
                          <div class="form-group{{ $errors->has('copyright') ? ' has-error' : '' }}">
                              {!! Form::label('copyright', __('adminWords.copyright') ) !!}
                              {!! Form::text('copyright', null, ['class' => 'form-control', 'placeholder'=>__('adminWords.enter').' '.__('adminWords.copyright'), 'rows'=>'3']) !!}
                              <small class="text-danger">{{ $errors->first('copyright') }}</small>
                          </div>
                          <div class="form-group{{$errors->has('image') ? 'has-error' : ''}}">
                            {!! Form::label('image', __('adminWords.audio').' '.__('adminWords.image'), ['class'=>'col-lg-12']) !!}
                            <label for="image" class="btn btn-danger js-labelFile" data-toggle="tooltip" data-original-title="Audio Image">
                              <i class="icon fa fa-check"></i>
                              {!! Form::file('image',['class' => 'basicImage form-control hide', 'name'=>'image', 'data-ext'=>"['jpg','jpeg','png']", 'data-image-id'=>'audioImage', 'data-label'=>'audio_imagee', 'data-image' => __('adminWords.image_error'),'accept' => 'image/*']) !!}
                              <span class="js-fileName">{{ __('adminWords.choose_image') }}</span>
                            </label>
                              <input type="hidden" name="image" id="image_name" value="{{(isset($audioData) ? $audioData->image:'')}}" placeholder="{{ __('Audio Image')}}">
                              <span class="image_title" id="audio_imagee">{{(isset($audioData) && $audioData->image != '' ? $audioData->image : __('adminWords.choose_image') )}}</span>
                              <small class="text-danger">{{ $errors->first('image')}}</small>
                              <input type="hidden" name="image" id="audioImage" placeholder="{{ __('Audio Image')}}" />
                              <p class="note_tooltip">Note: {{ __('adminWords.recommended').' size - 500X500 px' }} </p>
                          </div>
                          <div class="form-group{{ $errors->has('aws_upload') ? ' has-error' : '' }} switch-main-block">
                              <div class="row">
                                <div class="col-lg-3">
                                  {!! Form::label('aws_upload', __('adminWords.aws_upload')) !!}
                                </div>
                                <div class="col-lg-2">
                                    {!! Form::checkbox('aws_upload', 1, (isset($audioData) && $audioData->aws_upload == 0 ? 0 : 1), ['class' => 'js-switch-primary']) !!}
                                </div>
                              </div>
                              <small class="text-danger">{{ $errors->first('aws_upload') }}</small>
                          </div>
                          <div class="form-group{{$errors->has('audio') ? 'has-error' : ''}}">
                            {!! Form::label('audio', __('adminWords.audio'), ['class'=>'col-lg-12']) !!}
                            <label for="audio" class="btn btn-danger js-labelFile" data-toggle="tooltip" data-original-title="Audio">
                              <i class="icon fa fa-check"></i>
                              {!! Form::file('audio',['class' => 'basicImage form-control hide', 'name'=>'audio', 'data-ext'=>"['mp3','mp4']", 'data-audio-id'=>'audio', 'data-label'=>'audio_url']) !!}
                              <span class="js-fileName">{{ __('adminWords.choose_audio') }}</span>
                            </label>
                              <input type="hidden" id="audio_name" value="{{(isset($audioData) ? $audioData->audio:'')}}" placeholder="{{ __('Audio')}}">
                              <span class="image_title" id="audio_url">{{(isset($audioData) && $audioData->audio != '' ? $audioData->audio : __('adminWords.choose_audio') )}}</span>
                            <small class="text-danger">{{ $errors->first('audio')}}</small>
                          </div>
                      </div>
                      <div class="col-lg-6">
                            <div class="form-group{{ $errors->has('is_featured') ? ' has-error' : '' }} switch-main-block">
                                <div class="row">
                                    <div class="col-lg-3">
                                        {!! Form::label('is_featured', __('adminWords.featured') ) !!}
                                    </div>
                                    <div class="col-lg-2">
                                        {!! Form::checkbox('is_featured', 1, (isset($audioData) &&   $audioData->is_featured == 0 ? 0 : 1), ['class' => 'js-switch-primary']) !!}
                                    </div>
                                </div>
                                <small class="text-danger">{{ $errors->first('is_featured') }}</small>
                            </div>
                            <div class="form-group{{ $errors->has('is_trending') ? ' has-error' : '' }} switch-main-block">
                                <div class="row">
                                    <div class="col-lg-3">
                                        {!! Form::label('is_trending', __('adminWords.trending') ) !!}
                                    </div>
                                    <div class="col-lg-2">
                                        {!! Form::checkbox('is_trending', 1, (isset($audioData) && $audioData->is_trending == 0 ? 0 : 1), ['class' => 'js-switch-primary']) !!}
                                    </div>
                                </div>
                                <small class="text-danger">{{ $errors->first('is_trending') }}</small>
                            </div>
                            <div class="form-group{{ $errors->has('is_recommended') ? ' has-error' : '' }} switch-main-block">
                                <div class="row">
                                    <div class="col-lg-3">
                                        {!! Form::label('is_recommended', __('adminWords.recommended') ) !!}
                                    </div>
                                    <div class="col-lg-2">
                                        {!! Form::checkbox('is_recommended', 1, (isset($audioData) &&   $audioData->is_recommended == 0 ? 0 : 1), ['class' => 'js-switch-primary']) !!}
                                    </div>
                                </div>
                                <small class="text-danger">{{ $errors->first('is_recommended') }}</small>
                            </div>
                          <div class="form-group{{ $errors->has('status') ? ' has-error' : '' }} switch-main-block">
                              <div class="row">
                                <div class="col-lg-3">
                                  {!! Form::label('status', __('adminWords.status')) !!}
                                </div>
                                <div class="col-lg-2">
                                    {!! Form::checkbox('status', 1, (isset($audioData) &&   $audioData->status == 0 ? 0 : 1), ['class' => 'js-switch-primary']) !!}
                                </div>
                              </div>
                              <small class="text-danger">{{ $errors->first('status') }}</small>
                          </div>
                          <div class="form-group{{ $errors->has('lyrics') ? ' has-error' : '' }}">
                              {!! Form::label('lyrics', __('adminWords.lyrics') ) !!}
                              {!! Form::textarea('lyrics', null, ['id' => 'summernote', 'class' => 'form-control', 'placeholder'=>__('adminWords.enter').' '.__('adminWords.lyrics'), 'rows'=>'3']) !!}
                              <small class="text-danger">{{ $errors->first('adminWords.lyrics') }}</small>
                          </div>
                          <div class="form-group{{ $errors->has('description') ? ' has-error' : '' }}">
                              {!! Form::label('description', __('adminWords.description')) !!}
                              {!! Form::textarea('description', null, ['class' => 'form-control', 'placeholder'=> __('adminWords.enter').' '.__('adminWords.description'), 'rows'=>'3']) !!}
                              <small class="text-danger">{{ $errors->first('description') }}</small>
                          </div>
                      </div>
                      <div class="col-lg-8">
                        <div class="form-group"> 
                          @if(!isset($audioData))
                            <button type="reset" class="btn btn-danger" title="{{ __('adminWords.reset') }}"><i class="fa fa-ban"></i> {{ __('adminWords.reset') }}</button>
                          @endif  
                          <button type="button" class="btn btn-primary" data-action="submitThisForm"  title="{{ isset($audioData) ? __('adminWords.update') : __('adminWords.add') }}"><i class="fa fa-check-circle"></i> {{isset($audioData) ? __('adminWords.update') : __('adminWords.add') }}</button>  
                        </div>
                        <div class="clear-both"></div>
                      </div>
                    </div>
                    {!! Form::close() !!}
                  </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 
@section('script')
<script src="{{ asset('assets/plugins/datepicker/datepicker.min.js') }}"></script> 
<script src="{{asset('assets/plugins/summernote/summernote-bs4.min.js')}}"></script>
<script src="{{ asset('assets/plugins/datepicker/i18n/datepicker.en.js') }}"></script> 
<script src="{{ asset('assets/plugins/select2/select2.min.js') }}"></script> 
<script src="{{ asset('assets/plugins/switchery/switchery.min.js') }}"></script> 
<script src="{{ asset('assets/js/mrcls-custom.js') }}"></script>  

@endsection
