<?php
namespace Modules\Audio\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use DataTables;
use Illuminate\Support\Carbon;
use Modules\Audio\Entities\AudioGenre;
use Modules\Artist\Entities\ArtistGenre;
use Modules\Audio\Entities\AudioArtist;
use Modules\Audio\Entities\Audio;
use Modules\Artist\Entities\Artist;
use Modules\Language\Entities\Language;
use Stevebauman\Purify\Facades\Purify;
use Str;
use Auth;
use Crypt;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
class AudioController extends Controller
{
    public function index(){
        return view('audio::audio.index');
    }

    public function audioData(){
        $audios = select(['column' => ['audio.*', 'audio_genres.genre_name', 'languages.language_name'], 'table' => 'audio', 'order'=>['id','desc'], 'join' => [['audio_genres','audio_genres.id','=','audio.audio_genre_id'],['languages','languages.id','=','audio.audio_language']] ]);
        $newArr = [];
        if(!empty($audios)){
            foreach($audios as $audio){
                $artist_id = json_decode($audio->artist_id);
                $artist = Artist::select('artist_name')->where('id','=',$artist_id)->get();
                
                array_push($newArr,['id'=>$audio->id, 'audio_title'=>$audio->audio_title, 'audio_genre'=>$audio->genre_name, 'artist_name'=>(count($artist) > 0 ? $artist[0]['artist_name'] : '-'), 'language'=>$audio->language_name, 'created_at'=>$audio->created_at, 'status'=>$audio->status, 'image'=>$audio->image]);
            }
        }
        return DataTables::of($newArr)
            ->editColumn('checkbox',function($newArr){
                return '<div class="inline custom-checkbox"><input name="checked" id="checkboxAll'.$newArr['id'].'" type="checkbox" class="custom-control-input CheckBoxes" value="'.$newArr['id'].'"><label for="checkboxAll'.$newArr['id'].'" class="custom-control-label"></label></div>';
            })
            ->editColumn('image', function($newArr){
                if($newArr['image'] != '' && file_exists(public_path('/images/audio/thumb/'.$newArr['image'])))
                    $src = asset('/images/audio/thumb/'.$newArr['image']);
                else
                    $src = asset('images/sites/500x500.png');
                return '<img src="'.$src.'" alt="" class="img-fluid" width="60px" height="60px">';
            })
            ->editColumn('created_at', function($newArr){
                return Carbon::parse($newArr['created_at'])->diffForHumans(Carbon::now());
            })
            ->editColumn('status', function($newArr){
                return '<div class="custom-switch"><input id="switch'.$newArr['id'].'" name="status" class="custom-control-input changeStatus" '.($newArr['status'] == 1 ? 'checked':'').' type="checkbox" data-url="'.url('audio/status/'.$newArr['id']).'"><label class="custom-control-label" for="switch'.$newArr['id'].'"></label></div>';
            })
            ->addColumn('action', function ($newArr){
                return '<div class="button-list"><a class="btn btn-sm btn-success-rgba" href="'.url('audio/edit/'.$newArr['id']).'" ><i class="feather icon-edit-2"></i></a><a href="'.url('comments/audio/'.$newArr['audio_title'].'/'.Crypt::encrypt($newArr['id'])).'" class="btn btn-sm btn-info-rgba"><i class="fa fa-comment-o" aria-hidden="true"></i></a><button type="button" data-url="'.url('audio/destroy/'.$newArr['id']).'" class="btn btn-sm btn-danger-rgba" id="deleteUser"><i class="feather icon-trash"></i></button></div>';
            })
            ->rawColumns(['checkbox','image','status','action'])->make(true);
    }

    public function create(){
        $data['artist'] = Artist::pluck('artist_name','id')->all();
        $data['audioGenre'] = AudioGenre::where('status',1)->pluck('genre_name','id')->all();
        $data['language'] = Language::where('status',1)->pluck('language_name','id')->all();
        return view('audio::audio.addEdit', $data);
    }

    public function edit($id){
        $data['artist'] = Artist::pluck('artist_name','id')->all();
        $data['audioGenre'] = AudioGenre::pluck('genre_name','id')->all();
        $data['audioData'] = Audio::find($id);

        $data['language'] = Language::where('status',1)->pluck('language_name','id')->all();
        if(!empty($data['audioData'])){
            return view('audio::audio.addEdit', $data);
        }else{
            return redirect()->back();
        }
    }

    public function addEditAudio(Request $request, $id){
        $rules = [
            'audio_title' => 'required',
            'audio_genre_id' => 'required',
            'artist_id' => 'required',
            'audio_language' => 'required',
            'status' => 'required',
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',

        ];
        if(!is_numeric($id)){
            $rules['audio'] = 'required|mimes:mp3,mp4';
        }
     
        $checkValidate = validation($request->except('_token'), $rules);
        if($checkValidate['status'] == 1){
            $slug = Str::slug($request->audio_title,'-');
            $where = is_numeric($id) ? [['id','!=',$id],['audio_slug','=',$slug]] : [['audio_slug','=',$slug]];

            $checkAudio = Audio::where($where)->first();
            if(!empty($checkAudio)){
                $resp = array('status'=>0, 'msg'=>__('adminWords.audio').' '.__('adminWords.already_exist'));
            }else{
                $audioCheck = is_numeric($id) ? Audio::find($id) : [];
                $data = $request->except('_token');
                $data['lyrics'] = $data['lyrics'];
                $data['description'] = Purify::clean($data['description']);
                $data['audio_slug'] = $slug;
                $data['artist_id'] = json_encode($request->artist_id);
                $data['status'] = isset($request->status) ? 1 : 0;
                $data['is_featured'] = isset($request->is_featured) ? 1 : 0;
                $data['is_trending'] = isset($request->is_trending) ? 1 : 0;
                $data['is_recommended'] = isset($request->is_recommended) ? 1 : 0;
                $data['aws_upload'] = isset($request->aws_upload) ? 1 : 0;
                if ($file = $request->file('image')) {
                    $validator = Validator::make(
                        [
                            'image' => strip_tags($request->image),
                            'extension' => strtolower($request->image->getClientOriginalExtension()),
                        ],
                        [
                            'image' => 'required',
                            'extension' => 'required|in:jpg,png',
                        ]
                    );
                    if ($validator->fails()) {
                        return back()->withErrors( __('Invalid file !'));
                    }
                    if ($file = $request->file('image')) {
                        $name = time() . $file->getClientOriginalName();
                        $file->move('images/audio/thumb', $name);
                        $data['image'] = $name;
                    }
                }
                if($audio = $request->file('audio')){
                    $durationMp3 = 0;
                    if(!empty($audioCheck) && $audioCheck->audio != ''){
                        delete_file_if_exist(public_path().'/images/audio'.$audioCheck->audio);
                        if($exists = Storage::disk('s3')->exists('audios/' . $audioCheck->audio)){
                            Storage::disk('s3')->delete('audios/' . $audioCheck->audio);
                        }
                    }
                    if($data['aws_upload']){
                        $name = 'audio-'.time().rand(10,100) .'.'. $audio->getClientOriginalExtension();
                        $data['audio'] = str_replace(' ','',$name);
                        $audioName = Storage::disk('s3')->put('audios/'.$data['audio'], file_get_contents($audio), 'public');
                        if(isset($audioName)){
                            upload_audio(['audio'=>$audio, 'path'=>public_path().'/images/audio/aws/', 'filename'=>$data['audio']]);
                            $url = public_path().'/images/audio/aws/'.$data['audio'];
                            if(file_exists($url)){
                                $data['audio_duration'] = audio_duration([ 'path'=>$url]);
                                unlink($url);
                            }
                        }
                     
                    }else{
                        $audioName = 'audio-'.time().'.'.$audio->getClientOriginalExtension();
                        $data['audio'] = str_replace(' ','',$audioName);
                        upload_audio(['audio'=>$audio, 'path'=>public_path().'/images/audio', 'filename'=>$audioName]);
                        $data['audio_duration'] = audio_duration([ 'path' => public_path().'/images/audio/'.$data['audio'] ]);
                    }
                }
                
                $addAudio = !empty($audioCheck) ? $audioCheck->update($data) : Audio::create($data);
                if($addAudio){
                    foreach($request->artist_id as $artist){
                        $getAudioList = AudioArtist::where('artist_id',$artist)->get();
                        $idss = (!empty($audioCheck)) ? $id : $addAudio->id;  
                        if(sizeof($getAudioList) > 0){
                            $audioIds = json_decode($getAudioList[0]->audio_id);
                            if(!in_array($idss, $audioIds)){                   
                                array_push($audioIds, $idss);
                                $addupdatesong = AudioArtist::where('artist_id',$artist)->update(['audio_id'=>$audioIds]);
                            }
                        }else{
                            $dataArr = [
                                'artist_id' => $artist,
                                'audio_id' => (!empty($audioCheck)) ? json_encode([$id]) : json_encode([$addAudio->id])
                            ];
                            $addupdatesong = AudioArtist::create($dataArr);
                        }
                    }
                    $resp = array('status'=>1, 'msg'=>__('adminWords.audio').' '.__('adminWords.success_msg'));
                }else{
                    $resp = array('status'=>0, 'msg'=>__('adminWords.error_msg'));
                }
            }
        }else{
           $resp = $checkValidate;
        }
       echo json_encode($resp);
    }


    public function updateAudioStatus(Request $request, $id){
        $checkValidate = validation($request->all(), ['status'=>'required'] );
        if($checkValidate['status'] == 1){
            $resp = change_status(['table'=>'audio', 'where'=>['id'=>$id],'data'=> ['status'=>$request->status]]);
            echo $resp;
        }else{
            echo json_encode($checkValidate);
        }
    }

    public function destroyAudio($id){
        $resp = singleDelete([ 'table'=>'audio','column'=>['image','audio_title','audio','aws_upload'], 'where'=>['id'=>$id], 'msg'=>__('adminWords.audio').' '.__('adminWords.delete_success'), 'isImage'=>public_path().'/images/audio/','aws_upload'=>'1' ]);
        echo $resp;   
    }

    public function bulkDeleteAudio(Request $request){
        $checkValidate = validation($request->all(),['checked' =>'required'],__('adminWords.atleast').' '.__('adminWords.audio').' '.__('adminWords.must_selected') );
        if($checkValidate['status'] == 1){
            $resp = bulkDeleteData(['table'=>'audio','column'=>['id','image','audio','aws_upload'], 'msg'=>__('adminWords.audio').' '.__('adminWords.delete_success'), 'request'=>$request->except('_token'), 'isImage'=>public_path().'/images/audio/','aws_upload'=>'1']);
        }else{
            $resp = $checkValidate;
        }
        echo json_encode($resp);
    }


    public function audioGenres(){
        return view('audio::audio_category.index');
    }

    public function showAudioGenreData(){
        $audio_genre = select(['table'=>'audio_genres','column'=>'*','order'=>['id','desc']]);
        return DataTables::of($audio_genre)
        ->editColumn('checkbox',function($audio_genre){
            return '<div class="inline custom-checkbox"><input name="checked" id="checkboxAll'.$audio_genre->id.'" type="checkbox" class="custom-control-input CheckBoxes" value="'.$audio_genre->id.'"><label for="checkboxAll'.$audio_genre->id.'" class="custom-control-label"></label></div>';
        })
        ->editColumn('image', function($audio_genre){
            if($audio_genre->image != '' && file_exists(public_path('/images/audio/audio_genre/'.$audio_genre->image)))
                $src = asset('/images/audio/audio_genre/'.$audio_genre->image);
            else
                $src = asset('images/sites/500x500.png');
            return '<img src="'.$src.'" alt="" class="img-fluid" width="60px" height="60px">';
        })
        ->editColumn('created_at', function($audio_genre){
            return Carbon::parse($audio_genre->created_at)->diffForHumans(Carbon::now());
        })
        ->editColumn('status', function($audio_genre){
            return '<div class="custom-switch"><input id="switch'.$audio_genre->id.'" name="status" class="custom-control-input changeStatus" '.($audio_genre->status == 1 ? 'checked':'').' type="checkbox" data-url="'.url('updateAudioGenre/'.$audio_genre->id).'"><label class="custom-control-label" for="switch'.$audio_genre->id.'"></label></div>';
        })
        ->addColumn('action', function ($audio_genre){
            return '<div class="button-list"><a class="btn btn-sm btn-success-rgba audioGenrePopup" data-url="'.url('getAudioGenreData/'.$audio_genre->id).'" data-save="'.url('audio_genres/'.$audio_genre->id).'"><i class="feather icon-edit-2"></i></a><button type="button" data-url="'.url('destroyAudioGenre/'.$audio_genre->id).'" class="btn btn-sm btn-danger-rgba" id="deleteUser"><i class="feather icon-trash"></i></button></div>';
        })
        ->rawColumns(['checkbox','status','image','action'])->make(true);
    }

    public function getAudioGenreData($id){
        $genre = AudioGenre::find($id);
        if(!empty($genre)){
            $resp = ['status'=>1, 'data'=>$genre];
        }else{
            $resp = ['status'=>0, 'msg'=>__('adminWords.error_msg')];
        }
        echo json_encode($resp);
    }

    public function updateAudioGenre(Request $request, $id){ 
        $checkValidate = validation($request->all(),['status' =>'required']);
        if($checkValidate['status'] == 1){
            $resp = change_status(['table'=>'audio_genres', 'column'=>'id', 'where'=>['id'=>$id],'data'=> ['status'=>$request->status]]);
            echo $resp;
        }else{
            echo json_encode($checkValidate);
        }
    }

    public function addEditAudioGenre(Request $request, $id){
        $rules = ['genre_name' => 'required'];
        if(!is_numeric($id)){
            $rules['image'] = 'required|mimes:jpg,jpeg,png|max:2048';
        }
        $checkValidate = validation($request->except('_token'), $rules );
        if($checkValidate['status'] == 1){
            $arr = [
                'genre_name' => $request->genre_name,
                'genre_slug' => Str::slug($request->genre_name,'-'),
                'status' => isset($request->status) ? '1' : '0',
                'is_featured' => isset($request->is_featured) ? '1' : '0',
                'is_trending' => isset($request->is_trending) ? '1' : '0',
                'is_recommended' => isset($request->is_recommended) ? '1' : '0',
            ];
            $where = is_numeric($id) ? [['id','!=',$id], ['genre_slug','=', $arr['genre_slug']] ] : [['genre_slug','=', $arr['genre_slug']]];
            $audioGenre = AudioGenre::where($where)->get();
            if(count($audioGenre) > 0){
                $resp = ['status'=>0, 'msg'=>__('adminWords.genre').' '.__('adminWords.already_exist')];
            }else{
                $genre = is_numeric($id) ? AudioGenre::find($id) : [];
                if($image = $request->file('image')){
                    $name = 'audioGenre-'.time().'.webp';
                    $arr['image'] = str_replace(' ','',$name);
                    upload_image($image, public_path().'/images/audio/audio_genre/', $name, '500x500');
                    if(!empty($genre) && $genre->image != ''){
                        delete_file_if_exist(public_path().'/images/audio/audio_genre/'.$genre->image);
                    }
                }
                if(!empty($genre)){
                    $genre->update($arr);
                    $msg = __('adminWords.genre').' '.__('adminWords.updated_msg');
                }else{
                    AudioGenre::create($arr);
                    $msg = __('adminWords.genre').' '.__('adminWords.added_msg');
                }
                $resp = ['status'=>1, 'msg'=>$msg];
            }
        }else{
            $resp = $checkValidate;
        }
        echo json_encode($resp);
    }

    public function destroyAudioGenre($id){
        $resp = singleDelete([ 'table'=>'audio_genres','column'=>'id','where'=>['id'=>$id], 'msg'=>__('adminWords.genre').' '.__('adminWords.delete_success')]);
        echo $resp;
        
    }

    public function bulkDeleteAudioGenre(Request $request){
        $checkValidate = validation($request->all(),['checked' =>'required'],__('adminWords.atleast').' '.__('adminWords.genre').' '.__('adminWords.must_selected'));
        if($checkValidate['status'] == 1){
            $resp = bulkDeleteData(['table'=>'audio_genres', 'column'=>'id', 'msg'=>__('adminWords.genre').' '.__('adminWords.delete_success'),'request'=>$request->except('_token')]);
        }else{
            $resp = $checkValidate;
        }
        echo json_encode($resp);
    }

    public function audio_player(){
        return view('audio::audio');
    }

    
}
