@extends('layouts.admin.main')
@section('title', __('adminWords.artist'))
@section('style')
    <link href="{{ asset('assets/plugins/datatables/dataTables.bootstrap4.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('assets/plugins/datatables/buttons.bootstrap4.min.css') }}" rel="stylesheet" type="text/css" />
@endsection
@section('rightbar-content')

    <div class="breadcrumbbar">
        <div class="row align-items-center">
            <div class="col-md-7 col-lg-7">
                <h4 class="page-title">{{ __('adminWords.all') . ' ' . __('adminWords.artist') }}</h4>
                <div class="breadcrumb-list">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ url('/') }}"
                                title="{{ __('adminWords.home') }}">{{ __('adminWords.home') }}</a></li>
                        <li class="breadcrumb-item"><a href="#"
                                title="{{ __('adminWords.artist') }}">{{ __('adminWords.artist') }}</a></li>
                    </ol>
                </div>
            </div>
            <div class="col-md-5 col-lg-5">
                <div class="widgetbar">
                    <a class="btn btn-primary-rgba mr-2" href="{{ route('artist.create') }}" title="{{ __('adminWords.create') . ' ' . __('adminWords.artist') }}"><i
                            class="feather icon-plus mr-2"></i>{{ __('adminWords.create') . ' ' . __('adminWords.artist') }}</a>
                    <button type="button" class="btn btn-danger" id="bulkDelete"
                        data-msg="{{ __('adminWords.atleast') . __('adminWords.artist') . __('adminWords.must_selected') }}"
                        data-url="{{ route('artist.bulk_delete') }}" title="{{ __('adminWords.delete_selected') }}"><i class="fa fa-trash"></i>
                        {{ __('adminWords.delete_selected') }}</button>
                </div>
            </div>
        </div>
    </div>

    <div class="contentbar">
        <div class="row">
            <div class="col-lg-12">
                <div class="card m-b-30">
                    <div class="card-header">
                        <div class="row align-items-center">
                            <div class="col-6">
                                <h5 class="card-title mb-0">{{ __('adminWords.all') . ' ' . __('adminWords.artist') }}</h5>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <form method="post" id="artistForm">
                                <table data-method="post" id="datatable-buttons"
                                    class="table table-borderless mrclsDtToShowData" data-url="{{ route('artistData') }}">
                                    <thead>
                                        <tr>
                                            <th class="select-checkbox">
                                                <div class="inline custom-checkbox">
                                                    <input id="checkboxAll" type="checkbox"
                                                        class="custom-control-input selectAllUser"
                                                        onchange="checkAll(this, 'CheckBoxes')"  placeholder="{{ __('checkboxAll') }}">
                                                    <label for="checkboxAll" class="custom-control-label"></label>
                                                </div>
                                            </th>
                                            <th>{{ __('adminWords.image') }}</th>
                                            <th>{{ __('adminWords.artist_name') }}</th>
                                            <th>{{ __('adminWords.dob') }}</th>
                                            <th>{{ __('adminWords.artist_genres') }}</th>
                                            <th>{{ __('adminWords.created_at') }}</th>
                                            <th>{{ __('adminWords.status') }}</th>
                                            <th>{{ __('adminWords.action') }}</th>
                                        </tr>
                                    </thead>
                                </table>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script src="{{ asset('assets/plugins/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/dataTables.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/dataTables.buttons.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/buttons.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/jszip.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/pdfmake.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/vfs_fonts.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/buttons.html5.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/buttons.print.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/dataTables.responsive.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatables/responsive.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/sweetalert2/sweetalert2.min.js') }}"></script>
    <script src="{{ asset('assets/js/mrcls-custom.js') }}"></script>
@endsection
