@extends('layouts.admin.main')
@section('title', __('adminWords.artist'))
@section('style')
    <link href="{{ asset('assets/plugins/datepicker/datepicker.min.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('assets/plugins/select2/select2.min.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('assets/plugins/switchery/switchery.min.css') }}" rel="stylesheet" type="text/css">
@endsection
@section('rightbar-content')             
<div class="breadcrumbbar">
  <div class="row align-items-center">
    <div class="col-md-8 col-lg-8">
      <h4 class="page-title">{{isset($artistData) ? __('adminWords.update').' '.__('adminWords.artist') : __('adminWords.create').' '.__('adminWords.artist')}}</h4>
      <div class="breadcrumb-list">
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="{{url('/')}}" title="{{ __('adminWords.home')}}">{{ __('adminWords.home') }}</a></li>
          <li class="breadcrumb-item"><a href="#" title="{{ __('adminWords.artist')}}">{{ __('adminWords.artist') }}</a></li>
        </ol>
      </div>
    </div> 
  </div>          
</div>
   
<div class="contentbar">  
    <div class="row">
        <div class="col-lg-12">
            <div class="card m-b-30">
                <div class="card-header">    
                    <div class="text-right">   
                        <a class="btn btn-primary" href="{{ url('artist') }}" title="{{ __(' adminWords.go_back') }}">{{ __('adminWords.go_back') }}</a>
                    </div>                                 
                    <div class="row align-items-center">
                        <div class="col-6">
                        <h5 class="card-title mb-0">{{isset($artistData) ? __('adminWords.update').' '.__('adminWords.artist') : __('adminWords.create').' '.__('adminWords.artist')}}</h5>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                <div class="admin-form">
                    
                    @if(isset($artistData))
                      {!! Form::model($artistData, ['method'=>'post', 'files'=>true, 'route'=>['addEditArtist', $artistData->id], 'id'=>'updateArtist', 'onsubmit'=>'return false', 'data-redirect' => url('/artist')]) !!}
                    @else
                        {!! Form::open(['method' => 'POST', 'route' => ['addEditArtist','create'], 'id'=>'addUpdateArtistForm', 'enctype'=>"multipart/form-data", 'data-reset'=>"1", 'data-modal'=>'1', 'table-reload'=>"mrclsDtToShowData", 'data-redirect' => url('/artist') ]) !!}
                    @endif
                    <div class="row">
                        <div class="col-lg-6"> 
                            <div class="form-group{{ $errors->has('artist_name') ? ' has-error' : '' }}">
                                <label for="artist_name">{{ __('adminWords.artist_name') }}<sup>*</sup></label> 
                                {!! Form::text('artist_name', null, ['class' => 'form-control require', 'placeholder'=>__('adminWords.enter').' '.__('adminWords.artist_name')]) !!}
                                <small class="text-danger">{{ $errors->first('artist_name') }}</small>
                            </div>    
                                    
                            <div class="form-group{{$errors->has('dob') ? 'has-error' : ''}}">
                                {!! Form::label('dob', __('adminWords.dob')) !!}
                                <div class="input-group">
                                    {!! Form::text('dob', (isset($artistData) && $artistData->dob !='' ? $artistData->dob : ''), ['class' =>'form-control autoclose-date', 'data-language'=>'en', 'placeholder'=>__('adminWords.enter').' '.__('adminWords.dob') ]) !!}
                                    <div class="input-group-append">
                                        <span class="input-group-text" id="basic-addon3"><i class="feather icon-calendar"></i></span>
                                    </div>
                                </div>
                                <small class="text-danger">{{ $errors->first('adminWords.dob') }}</small>
                           </div>
                            <div class="form-group{{ $errors->has('description') ? ' has-error' : '' }}">
                                {!! Form::label('description', __('adminWords.description') ) !!}
                                {!! Form::textarea('description', null, ['class' => 'form-control', 'rows' => '6', 'placeholder'=> __('adminWords.enter').' '.__('adminWords.description') ]) !!}
                                <small class="text-danger">{{ $errors->first('description') }}</small>
                            </div>  
                        </div>
                        
                        <div class="col-lg-6">
                            <div class="form-group{{ $errors->has('artist_genre') ? ' has-error' : '' }}">
                                <label for="artist_genre">{{ __('adminWords.select').' '.__('adminWords.artist_genres') }}<sup>*</sup></label> 
                                {!! Form::select('artist_genre_id', $artistGenre, (isset($artistData) && $artistData->is_album_movie == 0 ? $artistData->artist_genre_id : ''), ['class' => 'form-control select2WithSearch require','placeholder' => __('adminWords.choose'), 'name'=>'artist_genre']) !!}
                                <small class="text-danger">{{ $errors->first('artist_genre') }}</small>
                            </div> 
                            <div class="form-group{{ $errors->has('status') ? ' has-error' : '' }} switch-main-block">
                                <div class="row">
                                    <div class="col-lg-3">
                                        {!! Form::label('status', __('adminWords.status') ) !!}
                                    </div>
                                    <div class="col-lg-2">
                                        {!! Form::checkbox('status', 1, (isset($artistData) && $artistData->status == 0 ? 0 : 1), ['class' => 'js-switch-primary']) !!}
                                    </div>
                                </div>
                                <small class="text-danger">{{ $errors->first('status') }}</small>
                            </div>
                            <div class="form-group{{ $errors->has('is_featured') ? ' has-error' : '' }} switch-main-block">
                                <div class="row">
                                    <div class="col-lg-3">
                                        {!! Form::label('is_featured', __('adminWords.featured')) !!}
                                    </div>
                                    <div class="col-lg-2">
                                        {!! Form::checkbox('is_featured', 1, (isset($artistData) &&   $artistData->is_featured == 0 ? 0 : 1), ['class' => 'js-switch-primary']) !!}
                                    </div>
                                </div>
                                <small class="text-danger">{{ $errors->first('is_featured') }}</small>
                            </div>
                            <div class="form-group{{ $errors->has('is_trending') ? ' has-error' : '' }} switch-main-block">
                                <div class="row">
                                    <div class="col-lg-3">
                                        {!! Form::label('is_trending', __('adminWords.trending')) !!}
                                    </div>
                                    <div class="col-lg-2">
                                        {!! Form::checkbox('is_trending', 1, (isset($artistData) &&   $artistData->is_trending == 0 ? 0 : 1), ['class' => 'js-switch-primary']) !!}
                                    </div>
                                </div>
                                <small class="text-danger">{{ $errors->first('is_trending') }}</small>
                            </div>
                            <div class="form-group{{ $errors->has('is_recommended') ? ' has-error' : '' }} switch-main-block">
                                <div class="row">
                                    <div class="col-lg-3">
                                        {!! Form::label('is_recommended', __('adminWords.recommended') ) !!}
                                    </div>
                                    <div class="col-lg-2">
                                        {!! Form::checkbox('is_recommended', 1, (isset($artistData) &&   $artistData->is_recommended == 0 ? 0 : 1), ['class' => 'js-switch-primary']) !!}
                                    </div>
                                </div>
                                <small class="text-danger">{{ $errors->first('is_recommended') }}</small>
                            </div>
                            <div class="form-group{{$errors->has('image') ? 'has-error' : ''}}">
                                <label for="image" class="col-lg-12">{{ __('adminWords.artist').' '.__('adminWords.image') }}<sup>*</sup></label> 
                                <label for="image" class="btn btn-danger js-labelFile" data-toggle="tooltip" data-original-title="Artist Image">
                                <i class="icon fa fa-check"></i>
                                {!! Form::file('image',['class' => 'form-control hide basicImage', 'data-label'=>'atristImage', 'id'=>'image', 'name'=>'image', 'data-ext'=>"['jpg','jpeg','png']", 'data-image-id'=>'artist_image', 'data-image'=>__('adminWords.image_error'),'accept' => 'image/*']) !!}
                                <span class="js-fileName">{{ __('adminWords.choose_image') }}</span>
                                </label>
                                <input type="hidden" name="image" id="image_name" value="{{(isset($artistData) ? $artistData->image:'')}}" placeholder="{{ __('Artist Image')}}">
                                <span class="image_title" id="atristImage">{{(isset($artistData) && $artistData->image != '' ? $artistData->image : __('adminWords.choose_image') )}}</span>
                                <small class="text-danger">{{ $errors->first('image')}}</small>
                                <input type="hidden" id="artist_image" name="image" placeholder="{{__('Artist Image')}}"/>
                                <p class="note_tooltip">Note: {{ __('adminWords.recommended').' size - 500X500 px' }} </p>
                            </div>
                        </div>
                        <div class="col-lg-8">
                            <div class="form-group"> 
                                @if(!isset($artistData))
                                    <button type="reset" class="btn btn-danger" title="{{ __('adminWords.reset') }}"><i class="fa fa-ban"></i> {{ __('adminWords.reset')}}</button>
                                @endif  
                                <button type="button" class="btn btn-primary" data-action="submitThisForm" title="{{ isset($artistData) ? __('adminWords.update') : __('adminWords.add') }}"><i class="fa fa-check-circle"></i> {{isset($artistData) ? __('adminWords.update') : __('adminWords.add') }}</button>  
                            </div>
                            <div class="clear-both"></div>
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 
@section('script')
    <script src="{{ asset('assets/plugins/datepicker/datepicker.min.js') }}"></script> 
    <script src="{{ asset('assets/plugins/select2/select2.min.js') }}"></script> 
    <script src="{{ asset('assets/plugins/datepicker/i18n/datepicker.en.js') }}"></script> 
    <script src="{{ asset('assets/plugins/switchery/switchery.min.js') }}"></script> 
    <script src="{{ asset('assets/js/mrcls-custom.js') }}"></script>  
@endsection
