@extends('layouts.admin.main')
@section('title', __('adminWords.album'))
@section('style')
    <link href="{{ asset('assets/plugins/datepicker/datepicker.min.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('assets/plugins/select2/select2.min.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('assets/plugins/switchery/switchery.min.css') }}" rel="stylesheet" type="text/css">
@endsection
@section('rightbar-content')               
<div class="breadcrumbbar">
  <div class="row align-items-center">
    <div class="col-md-8 col-lg-8">
      <h4 class="page-title">{{!empty($albumData) ? __('adminWords.update').' '.__('adminWords.album') : __('adminWords.create').' '.__('adminWords.album') }}</h4>
      <div class="breadcrumb-list">
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="{{url('/')}}" title="{{ __('adminWords.home')}}">{{ __('adminWords.home')}}</a></li>
          <li class="breadcrumb-item"><a href="#" title="{{ __('adminWords.album')}}">{{ __('adminWords.album')}}</a></li>
        </ol>
      </div>
    </div> 
  </div>          
</div>
  
<div class="contentbar">  
    <div class="row">
        <div class="col-lg-12">
            <div class="card m-b-30">
                <div class="card-header"> 
                    <div class="text-right">   
                        <a class="btn btn-primary" href="{{ url('album') }}" title="{{ __('adminWords.go_back') }}">{{ __('adminWords.go_back') }}</a>
                    </div>                               
                    <div class="row align-items-center">
                        <div class="col-6">
                        <h5 class="card-title mb-0"> {{!empty($albumData) ? __('adminWords.update').' '.__('adminWords.album') : __('adminWords.create').' '.__('adminWords.album') }}</h5>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                <div class="admin-form">
                    
                    @if(!empty($albumData))
                      {!! Form::model($albumData, ['method'=>'post', 'files'=>true, 'route'=>['addEditAlbum', $albumData->id], 'id'=>'updateUser', 'onsubmit'=>'return false', 'data-redirect' => url('/album')]) !!}
                    @else
                        {!! Form::open(['method' => 'POST', 'route' => ['addEditAlbum','create'], 'id'=>'addUpdateAlbumForm', 'enctype'=>"multipart/form-data", 'data-reset'=>"1", 'data-redirect' => url('/album') ]) !!}
                    @endif
                    <div class="row">
                        <div class="col-lg-6"> 
                            <div class="form-group{{ $errors->has('album_name') ? ' has-error' : '' }}">
                                <label for="album_name">{{ __('adminWords.album').' '.__('adminWords.name') }}<sup>*</sup></label> 
                                {!! Form::text('album_name', null, ['class' => 'form-control require', 'placeholder'=> __('adminWords.enter').' '.__('adminWords.album').' '.__('adminWords.name')]) !!}
                                <small class="text-danger">{{ $errors->first('album_name') }}</small>
                            </div>    
                                    
                            <div class="form-group{{ $errors->has('copyright') ? ' has-error' : '' }}">
                                {!! Form::label('copyright', __('adminWords.copyright')) !!}
                                {!! Form::text('copyright', null, ['class' => 'form-control', 'placeholder'=>__('adminWords.enter').' '.__('adminWords.copyright')]) !!}
                                <small class="text-danger">{{ $errors->first('copyright') }}</small>
                            </div>
                        
                            <div class="form-group{{ $errors->has('song_list') ? ' has-error' : '' }}">
                                <label for="song_list">{{ __('adminWords.select').' '.__('adminWords.song')}}<sup>*</sup></label> 
                                <select name="song_list[]" id="" class="form-control multipleSelectWithSearch require" data-placeholder="{{ __('adminWords.choose')}}"  multiple="multiple">
                                    @foreach($song_list as $song)
                                        <option value="{{$song->id}}" @if(isset($albumData) && !empty($albumData)) @foreach(json_decode($albumData->song_list) as $sid) {{ $sid == $song->id ? "selected" : "" }} @endforeach @endif >{{ $song->audio_title }}</option> 
                                    @endforeach
                                </select>
                            </div>
                            
                            <div class="form-group{{ $errors->has('language_id') ? ' has-error' : '' }}">
                                <label for="language">{{ __('adminWords.select').' '.__('adminWords.language') }}<sup>*</sup></label> 
                                {!! Form::select('language_id', $language, (!empty($albumData) ? $albumData->language_id : ''), ['class' => 'form-control select2WithSearch require','placeholder' => __('adminWords.choose')]) !!}
                                <small class="text-danger">{{ $errors->first('language_id') }}</small>
                            </div> 
                            <div class="form-group{{ $errors->has('description') ? ' has-error' : '' }}">
                                {!! Form::label('description', __('description')) !!}
                                {!! Form::textarea('description', null, ['class' => 'form-control', 'rows' => '3', 'placeholder'=> __('adminWords.enter').' '.__('adminWords.description')]) !!}
                                <small class="text-danger">{{ $errors->first('adminWords.description') }}</small>
                            </div>  
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group{{ $errors->has('status') ? ' has-error' : '' }} switch-main-block">
                                <div class="row">
                                    <div class="col-lg-3">
                                        {!! Form::label('status', __('adminWords.status')) !!}
                                    </div>
                                    <div class="col-lg-2">
                                        {!! Form::checkbox('status', 1, (!empty($albumData) &&   $albumData->status == 0 ? 0 : 1), ['class' => 'js-switch-primary']) !!}
                                    </div>
                                </div>
                                <small class="text-danger">{{ $errors->first('status') }}</small>
                            </div>
                            <div class="form-group{{ $errors->has('is_featured') ? ' has-error' : '' }} switch-main-block">
                                <div class="row">
                                    <div class="col-lg-3">
                                        {!! Form::label('is_featured', __('adminWords.featured')) !!}
                                    </div>
                                    <div class="col-lg-2">
                                        {!! Form::checkbox('is_featured', 1, (!empty($albumData) &&   $albumData->is_featured == 0 ? 0 : 1), ['class' => 'js-switch-primary']) !!}
                                    </div>
                                </div>
                                <small class="text-danger">{{ $errors->first('is_featured') }}</small>
                            </div>
                            <div class="form-group{{ $errors->has('is_trending') ? ' has-error' : '' }} switch-main-block">
                                <div class="row">
                                    <div class="col-lg-3">
                                        {!! Form::label('is_trending', __('adminWords.trending')) !!}
                                    </div>
                                    <div class="col-lg-2">
                                        {!! Form::checkbox('is_trending', 1, (!empty($albumData) &&   $albumData->is_trending == 0 ? 0 : 1), ['class' => 'js-switch-primary']) !!}
                                    </div>
                                </div>
                                <small class="text-danger">{{ $errors->first('is_trending') }}</small>
                            </div>
                            <div class="form-group{{ $errors->has('is_recommended') ? ' has-error' : '' }} switch-main-block">
                                <div class="row">
                                    <div class="col-lg-3">
                                        {!! Form::label('is_recommended', __('adminWords.recommended')) !!}
                                    </div>
                                    <div class="col-lg-2">
                                        {!! Form::checkbox('is_recommended', 1, (!empty($albumData) &&   $albumData->is_recommended == 0 ? 0 : 1), ['class' => 'js-switch-primary']) !!}
                                    </div>
                                </div>
                                <small class="text-danger">{{ $errors->first('is_recommended') }}</small>
                            </div>
                            <div class="form-group{{ $errors->has('is_verified') ? ' has-error' : '' }} switch-main-block">
                                <div class="row">
                                    <div class="col-lg-3">
                                        {!! Form::label('is_verified', __('adminWords.verified')) !!}
                                    </div>
                                    <div class="col-lg-2">
                                        {!! Form::checkbox('is_verified', 1, (!empty($albumData) &&   $albumData->is_verified == 0 ? 0 : 1), ['class' => 'js-switch-primary']) !!}
                                    </div>
                                </div>
                                <small class="text-danger">{{ $errors->first('is_verified') }}</small>
                            </div>
                            <div class="form-group{{$errors->has('image') ? 'has-error' : ''}}">
                                <label for="image" class="col-lg-12">{{ __('adminWords.album').' '.__('adminWords.image') }}<sup>*</sup></label> 
                                <label for="image" class="btn btn-danger js-labelFile" data-toggle="tooltip" data-original-title="Album Image">
                                <i class="icon fa fa-check"></i>
                                {!! Form::file('image',['class' => 'form-control hide basicImage', 'data-label'=>'albumImage', 'name'=>'image', 'data-ext'=>"['jpg','jpeg','png']", 'data-image-id'=>'album_image', 'id'=>'image','accept'=>'image/*']) !!}
                                <span class="js-fileName">{{__('adminWords.choose_image')}}</span>
                                </label>
                                <input type="hidden" name="image" id="image_name" value="{{(!empty($albumData) ? $albumData->image:'')}}" placeholder="{{ __('Show Album')}}">
                                <span class="image_title" id="albumImage">{{(!empty($albumData) && $albumData->image != '' ? $albumData->image : __('adminWords.choose_image') )}}</span>
                                <small class="text-danger">{{ $errors->first('image')}}</small>
                                <input type="hidden" name="image" id="album_image" placeholder="{{ __('Album Image')}}"/>
                                <p class="note_tooltip">Note: {{ __('adminWords.recommended').' size - 500X500 px' }} </p>
                            </div>
                            
                            <div class="form-group{{$errors->has('is_album_movie') ? 'has-error' : ''}}">
                                <label for="is_album_movie">{{  __('adminWords.album').'/'.__('adminWords.movie') }}<sup>*</sup></label> 
                                <div class="custom-control custom-radio custom-control-inline">
                                    {!! Form::radio('is_album_movie', 1, (!empty($albumData) && $albumData->is_album_movie == 1 || empty($albumData) ? 'checked' : ''), ['class' => 'custom-control-input', 'id'=>'album']) !!}
                                    {!! Form::label('album', null, ['class' => 'custom-control-label']) !!}
                                </div>
                                <div class="custom-control custom-radio custom-control-inline">
                                    {!! Form::radio('is_album_movie', 0, (!empty($albumData) && $albumData->is_album_movie == 0 ? 'checked' : (!empty($albumData) ? 'checked' : '')), ['class' => 'custom-control-input', 'id'=>'movie']) !!}
                                    {!! Form::label('movie', null, ['class' => 'custom-control-label']) !!}
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-8">
                            <div class="form-group"> 
                                @if(empty($albumData))
                                    <button type="reset" class="btn btn-danger"><i class="fa fa-ban"></i> {{ __('adminWords.reset')}}</button>
                                @endif  
                                <button type="button" class="btn btn-primary" data-action="submitThisForm"><i class="fa fa-check-circle"></i> {{!empty($albumData) ? __('adminWords.update') : __('adminWords.add') }}</button>  
                            </div>
                            <div class="clear-both"></div>
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
                 
            </div>
        </div>
    </div>
</div>
@endsection 
@section('script')
    <script src="{{ asset('assets/plugins/datepicker/datepicker.min.js') }}"></script> 
    <script src="{{ asset('assets/plugins/select2/select2.min.js') }}"></script> 
    <script src="{{ asset('assets/plugins/datepicker/i18n/datepicker.en.js') }}"></script> 
    <script src="{{ asset('assets/plugins/switchery/switchery.min.js') }}"></script> 
    <script src="{{ asset('assets/js/mrcls-custom.js') }}"></script>  
@endsection
