<?php

namespace Modules\Album\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use DataTables;
use Modules\Album\Entities\Album;
use Modules\Audio\Entities\Audio;
use Illuminate\Support\Carbon;
use Str;
use Modules\Language\Entities\Language;
use Illuminate\Support\Facades\Validator;
class AlbumController extends Controller
{
    public function index(){
        return view('album::index');
    } 

    public function albumData(){
        $albums = select(['column' => ['albums.id','albums.image','albums.album_name','albums.copyright','albums.song_list','albums.is_album_movie', 'albums.status', 'albums.created_at'], 'table' => 'albums', 'order'=>['id','desc'] ]);
        return DataTables::of($albums)
            ->editColumn('checkbox',function($albums){
                return '<div class="inline custom-checkbox"><input name="checked" id="checkboxAll'.$albums->id.'" type="checkbox" class="custom-control-input CheckBoxes" value="'.$albums->id.'"><label for="checkboxAll'.$albums->id.'" class="custom-control-label"></label></div>';
            })
            ->editColumn('image', function($albums){
                if($albums->image != '' && file_exists(public_path('/images/album/'.$albums->image)))
                    $src = asset('/images/album/'.$albums->image);
                else
                    $src = asset('images/sites/500x500.png');
                return '<img src="'.$src.'" alt="" class="img-fluid" width="60px" height="60px">';
            })
            ->editColumn('album_movie', function($albums){
                return ($albums->is_album_movie == 1) ? __('adminWords.album') : __('adminWords.movie');
            })
            ->editColumn('created_at', function($albums){ 
                return Carbon::parse($albums->created_at)->diffForHumans(Carbon::now());
            })
            ->editColumn('status', function($albums){
                return '<div class="custom-switch"><input id="switch'.$albums->id.'" name="status" class="custom-control-input changeStatus" '.($albums->status == 1 ? 'checked':'').' type="checkbox" data-url="'.url('albums/status/'.$albums->id).'"><label class="custom-control-label" for="switch'.$albums->id.'"></label></div>';
            })
            ->addColumn('action', function ($albums) {
                return '<div class="button-list"><a class="btn btn-sm btn-success-rgba" href="'.url('albums/edit/'.$albums->id).'"><i class="feather icon-edit-2"></i></a><button type="button" data-url="'.url('albums/destroy/'.$albums->id).'" class="btn btn-sm btn-danger-rgba" id="deleteUser"><i class="feather icon-trash"></i></button></div>';
            })
            ->rawColumns(['checkbox','image','status','action'])->make(true);
    }

    public function addEditAlbum(Request $request, $id){
        $rules = [ 'album_name' => 'required',
                    'song_list' => 'required', 
                    'language_id' => 'required',
                    'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',

    ];
        $checkValidate = validation($request->except('_token'), $rules);
        if($checkValidate['status'] == 1){
            $slug = Str::slug($request->album_name,'-');
            $where = is_numeric($id) ? [['id','!=',$id],['album_slug','=',$slug]] : [['album_slug','=',$slug]];
            $checkAlbum = Album::where($where)->first();
            if(!empty($checkAlbum) > 0){
                $resp = array('status'=>0, 'msg'=> __('adminWords.album').' '.__('adminWords.already_exist'));
            }else{
                $checkAlbum = is_numeric($id) ? Album::find($id) : [];
                $data = $request->except('_token');
                $data['song_list'] = json_encode($request->song_list);
                $data['album_slug'] = $slug;
                $data['status'] = isset($request->status) ? 1 : 0;
                $data['language_id'] = $request->language_id;
                $data['is_album_movie'] = $request->is_album_movie;
                $data['is_featured'] = isset($request->is_featured) ? 1 : 0;
                $data['is_trending'] = isset($request->is_trending) ? 1 : 0;
                $data['is_recommended'] = isset($request->is_recommended) ? 1 : 0;
                $data['is_verified'] = isset($request->is_verified) ? 1 : 0;
                // ========================================
                if ($file = $request->file('image')) {
                    $validator = Validator::make(
                        [
                            'image' => strip_tags($request->image),
                            'extension' => strtolower($request->image->getClientOriginalExtension()),
                        ],
                        [
                            'image' => 'required',
                            'extension' => 'required|in:jpg,png',
                        ]
                    );
                    if ($validator->fails()) {
                        return back()->withErrors( __('Invalid file !'));
                    }
                    if ($file = $request->file('image')) {
                        $name = time() . $file->getClientOriginalName();
                        $file->move('images/album', $name);
                        $data['image'] = $name;
                    }
                }
                
                $addAlbum = empty($checkAlbum) ? Album::create($data) : $checkAlbum->update($data);
                $resp = ($addAlbum) ? ['status'=>1, 'msg'=> __('adminWords.album').' '.__('adminWords.success_msg')] : ['status'=>0, 'msg'=> __('adminWords.error_msg') ];
            }
        }else{
           $resp = $checkValidate;
        }
       echo json_encode($resp);
    }
    
    public function createAlbum(){
        $data['albumData'] = [];
        $data['song_list'] = Audio::where('status', 1)->orderBy('id', 'desc')->get();
        $data['language'] = Language::where('status',1)->pluck('language_name','id')->all();
        return view('album::addEdit', $data);
    }

    public function editAlbum($id){
        $albumData = Album::where('id',$id)->get();
        if(sizeof($albumData) > 0 ){
            $data['albumData'] = $albumData[0];
            $data['song_list'] = Audio::where('status', 1)->orderBy('id', 'desc')->get();
            $data['language'] = Language::where('status',1)->pluck('language_name','id')->all();
            return view('album::addEdit', $data);
        }else{
            return redirect('album');
        }
    }

    function updateAlbumStatus(Request $request, $id){
        $checkValidate = validation($request->all(),['status' =>'required']);
        if($checkValidate['status'] == 1){
            $resp = change_status(['table'=>'albums', 'column'=>'id', 'where'=>['id'=>$id],'data'=> ['status'=>$request->status]]);
            echo $resp;
        }else{
            echo json_encode($checkValidate);
        }
    }

    public function destroyAlbum($id){
        $resp = singleDelete([ 'table'=>'albums','column'=>['image','album_name'], 'where'=>['id'=>$id], 'msg'=> __('adminWords.album').' '.__('adminWords.delete_success'), 'isImage'=>public_path().'/images/album/' ]);
        echo $resp;        
    }

    function bulkDeletePlanData(Request $request){
        $checkValidate = validation($request->all(),['checked' =>'required'], __('adminWords.atleast').__('adminWords.plan').__('adminWords.must_selected'));
        if($checkValidate['status'] == 1){
            $resp = bulkDeleteData(['table'=>'plans','column'=>'id', 'msg'=>__('adminWords.plan').' '.__('adminWords.delete_success'), 'request'=>$request->except('_token')]);
        }else{
            $resp = $checkValidate;
        }
        echo json_encode($resp);
    }

}