@extends('layouts.admin.main')
@section('title', isset($advData) ? __('adminWords.update') . ' ' . __('adminWords.adv') : __('adminWords.create') . ' '
    . __('adminWords.adv'))
@section('style')
    <link href="{{ asset('assets/plugins/datepicker/datepicker.min.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('assets/plugins/select2/select2.min.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('assets/plugins/switchery/switchery.min.css') }}" rel="stylesheet" type="text/css">
@endsection
@section('rightbar-content')
    <div class="breadcrumbbar">
        <div class="row align-items-center">
            <div class="col-md-8 col-lg-8">
                <h4 class="page-title">
                    {{ isset($advData) ? __('adminWords.update') . ' ' . __('adminWords.adv') : __('adminWords.create') . ' ' . __('adminWords.adv') }}
                </h4>
                <div class="breadcrumb-list">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ url('/') }}"
                                title="{{ __('adminWords.home') }}">{{ __('adminWords.home') }}</a></li>
                        <li class="breadcrumb-item"><a href="#"
                                title="{{ __('adminWords.adv') }}">{{ __('adminWords.adv') }}</a></li>
                    </ol>
                </div>
            </div>
            <div class="col-md-4 col-lg-4">
            </div>
        </div>
    </div>

    <div class="contentbar">
        <div class="row">
            <div class="col-lg-12">
                <div class="card m-b-30">
                    <div class="card-header">
                        <div class="text-right">
                            <a class="btn btn-primary" href="{{ url('advertisement') }}" title="{{ __('adminWords.go_back') }}">{{ __('adminWords.go_back') }}</a>
                        </div>
                        <div class="row align-items-center">
                            <div class="col-6">
                                <h5 class="card-title mb-0">
                                    {{ isset($advData) ? __('adminWords.update') . ' ' . __('adminWords.adv') : __('adminWords.create') . ' ' . __('adminWords.adv') }}
                                </h5>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="admin-form">

                            @if (isset($advData))
                                {!! Form::model($advData, [
                                    'method' => 'post',
                                    'files' => true,
                                    'route' => ['addEditAdv', $advData->id],
                                    'id' => 'updateUser',
                                    'onsubmit' => 'return false',
                                    'data-redirect' => url('/advertisement'),
                                ]) !!}
                            @else
                                {!! Form::open([
                                    'method' => 'POST',
                                    'route' => ['addEditAdv', 'create'],
                                    'id' => 'addUpdateAlbumForm',
                                    'enctype' => 'multipart/form-data',
                                    'data-reset' => '1',
                                    'data-modal' => '1',
                                    'table-reload' => 'mrclsDtToShowData',
                                    'data-redirect' => url('/advertisement'),
                                ]) !!}
                            @endif
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="form-group{{ $errors->has('title') ? ' has-error' : '' }}">
                                        <label for="title">{{ __('adminWords.title') }}<sup>*</sup></label>
                                        {!! Form::text('title', null, [
                                            'class' => 'form-control require',
                                            'placeholder' => __('adminWords.enter') . ' ' . __('adminWords.title'),
                                        ]) !!}
                                        <small class="text-danger">{{ $errors->first('adminWords.title') }}</small>
                                    </div>
                                    <div class="form-group{{ $errors->has('google_adsense_script') ? ' has-error' : '' }}">
                                        <label
                                            for="google_adsense_script">{{ __('adminWords.google_adsense_script') }}<sup>*</sup></label>
                                        {!! Form::textarea('google_adsense_script', null, [
                                            'class' => 'form-control require',
                                            'rows' => '5',
                                            'placeholder' => __('adminWords.enter') . ' ' . __('adminWords.google_adsense_script'),
                                        ]) !!}
                                        <small
                                            class="text-danger">{{ $errors->first('adminWords.google_adsense_script') }}</small>
                                    </div>
                                </div>
                                <div class="col-lg-8">
                                    <div class="form-group">
                                        @if (!isset($advData))
                                            <button type="reset" class="btn btn-danger" title="{{ __('adminWords.reset') }}"><i class="fa fa-ban"></i>
                                                {{ __('adminWords.reset') }}</button>
                                        @endif
                                        <button type="button" class="btn btn-primary" data-action="submitThisForm" title="{{ isset($advData) ? __('adminWords.update') : __('adminWords.add') }}"><i
                                                class="fa fa-check-circle"></i>
                                            {{ isset($advData) ? __('adminWords.update') : __('adminWords.add') }}</button>
                                    </div>
                                    <div class="clear-both"></div>
                                </div>
                            </div>
                            {!! Form::close() !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endsection
    @section('script')
        <script src="{{ asset('assets/plugins/datepicker/datepicker.min.js') }}"></script>
        <script src="{{ asset('assets/plugins/select2/select2.min.js') }}"></script>
        <script src="{{ asset('assets/plugins/datepicker/i18n/datepicker.en.js') }}"></script>
        <script src="{{ asset('assets/plugins/switchery/switchery.min.js') }}"></script>
        <script src="{{ asset('assets/js/mrcls-custom.js') }}"></script>
    @endsection
